/* **************************************************************************
*                                                                           *
*  Lock.CPP                                                                 *
*                                                                           *
*  03-03-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Control de les regions bloquejades dels fitxers                          *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "drivers\fs\private\lock.h"

// **************************************************************************
// Constructor de la classe
// Com a entrada ha de rebre:
// FCB      	- Fitxer sobre el qual es fa el bloqueig
// Process  	- Procs que demana el bloqueig
// Position 	- Posici on comena la zona bloquejada
// Size     	- Tamany de la zona bloquejada
CLock::CLock( PCGlobalFile pFCB, PCkeProcess pProc, DWORD dwPosition, DWORD dwSize ) : CkeDblListItem( NULL, NULL )
	{
	pfile			= pFCB;
	pproc 		= pProc;
	dwposition 	= dwPosition;
	dwsize 		= dwSize;
	}

// **************************************************************************
// Destructor de la classe
CLock::~CLock()
	{
	}

// **************************************************************************
// Obt el fitxer sobre el qual s'aplica un bloqueig
PCGlobalFile CLock::File()
	{
	return pfile;
	}

// **************************************************************************
// Obt el procs que t el control d'una certa zona
PCkeProcess CLock::Process()
	{
	return pproc;
	}

// **************************************************************************
// Obt la posici d'inici de la zona controlada
DWORD CLock::Position()
	{
	return dwposition;
	}

// **************************************************************************
// Obt el tamany de la zona reservada
DWORD CLock::Size()
	{
	return dwsize;
	}

// **************************************************************************
// Selecciona un nou fitxer controlat
// Com a entrada ha de rebre:
// FCB      	- Fitxer sobre el qual realitzem el bloqueig
VOID CLock::File( PCGlobalFile pFCB )
	{
	pfile = pFCB;
	}

// **************************************************************************
// Selecciona un nou procs per al control de la zona
// Com a entrada ha de rebre:
// Proc		  	- Procs que demana la informaci
VOID CLock::Process( PCkeProcess pProc )
	{
	pproc = pProc;
	}

// **************************************************************************
// Selecciona una nova posici inicial de la zona
// Com a entrada ha de rebre:
// Position 	- Posici inicial de la zona
VOID CLock::Position( DWORD dwPosition )
	{
	dwposition = dwPosition;
	}

// **************************************************************************
// Selecciona un nou tamany per al bloqueig
// Com a entrada ha de rebre:
// Size     	- Tamany de la zona
VOID CLock::Size( DWORD dwSize )
	{
	dwsize = dwSize;
	}

