/* **************************************************************************
*                                                                           *
*  FUB.CPP                                                                  *
*                                                                           *
*  03-03-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classe genrica per al control de fitxers d'usuari                       *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "drivers\fs\fub.h"
#include "drivers\messages.h"
#include "kernel\system.h"
#include "errors.h"
extern PCkeSystem _import System;
#ifdef _DEBUG
extern DWORD _import DebugLevel;
#endif

CdrvUserFile::CdrvUserFile( PSTR sName, BYTE cMode, BYTE cShare )
	{
	PCkeProcess pproc = (System->Running())->Process();
	pfsmail = (PCkeMailBox) System->FindObject( sName );

	PCkeMailBox box = new CkeMailBox( NULL );

	TData data;
	data.dwParam1 = (DWORD) sName;
	data.dwParam2 = (DWORD) cMode;
	data.dwParam3 = (DWORD) cShare;
	data.dwParam4 = (DWORD) pproc;	// Fa falta? -BUG

	TMSG msg;

	msg.dwMessage	= DRV_OPENFILE_FS;
	msg.dwParam1	= (DWORD) pfsmail;
	msg.dwParam2	= (DWORD) &data;
	msg.pReply		= box;

	pfsmail->PostMessage( &msg );

	box->WaitMessage( &msg );
	DWORD temp = msg.dwParam1;

	if( !temp )
		dwstatus = FIL_NOFILE;
	else
		dwstatus = OK;

	msg.dwMessage	= DRV_CREATEUSERFILE_FCB;
	msg.dwParam1	= temp;
	msg.dwParam2	= (DWORD) pproc;
	msg.pReply		= box;

	pfsmail->PostMessage( &msg );

	box->WaitMessage( &msg );
	delete box;

	pobject = (PVOID) msg.dwParam1;
	}

CdrvUserFile::~CdrvUserFile()
	{
	PCkeMailBox box = new CkeMailBox( NULL );

	TMSG msg;

	msg.dwMessage	= DRV_CLOSEFILE_FUB;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 0;
	msg.pReply		= box;

	pfsmail->PostMessage( &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CdrvUserFile::Lock( DWORD dwBegin, DWORD dwSize, DWORD dwProtection )
	{
	PCkeMailBox box = new CkeMailBox( NULL );

	TData data;
	data.dwParam1 = dwBegin;
	data.dwParam2 = dwSize;
	data.dwParam3 = dwProtection;

	TMSG msg;

	msg.dwMessage	= DRV_LOCKFILE_FUB;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= (DWORD) &data;
	msg.pReply		= box;

	pfsmail->PostMessage( &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CdrvUserFile::Unlock( DWORD dwBegin, DWORD dwSize )
	{
	PCkeMailBox box = new CkeMailBox( NULL );

	TData data;
	data.dwParam1 = dwBegin;
	data.dwParam2 = dwSize;

	TMSG msg;

	msg.dwMessage	= DRV_UNLOCKFILE_FUB;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= (DWORD) &data;
	msg.pReply		= box;

	pfsmail->PostMessage( &msg );

	box->WaitMessage( &msg );
	delete box;
	}

DWORD CdrvUserFile::Read( PVOID pBuffer, DWORD dwSize )
	{
	PCkeMailBox box = new CkeMailBox( NULL );

	TData data;
	data.dwParam1 = (DWORD) pBuffer;
	data.dwParam2 = dwSize;

	TMSG msg;

	msg.dwMessage	= DRV_READFILE_FUB;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= (DWORD) &data;
	msg.pReply		= box;

	pfsmail->PostMessage( &msg );

	box->WaitMessage( &msg );
	delete box;

	return msg.dwParam1;
	}

DWORD CdrvUserFile::Write( PVOID pBuffer, DWORD dwSize )
	{
	PCkeMailBox box = new CkeMailBox( NULL );

	TData data;
	data.dwParam1 = (DWORD) pBuffer;
	data.dwParam2 = dwSize;

	TMSG msg;

	msg.dwMessage	= DRV_WRITEFILE_FUB;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= (DWORD) &data;
	msg.pReply		= box;

	pfsmail->PostMessage( &msg );

	box->WaitMessage( &msg );
	delete box;

	return msg.dwParam1;
	}

DWORD CdrvUserFile::Seek( LONG lBytes, BYTE cFrom )
	{
	PCkeMailBox box = new CkeMailBox( NULL );

	TData data;
	data.dwParam1 = (DWORD) lBytes;
	data.dwParam2 = (DWORD) cFrom;

	TMSG msg;

	msg.dwMessage	= DRV_SEEKFILE_FUB;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= (DWORD) &data;
	msg.pReply		= box;

	pfsmail->PostMessage( &msg );

	box->WaitMessage( &msg );
	delete box;

	return msg.dwParam1;
	}

VOID CdrvUserFile::Flush()
	{
	PCkeMailBox box = new CkeMailBox( NULL );

	TMSG msg;

	msg.dwMessage	= DRV_FLUSHFILE_FUB;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 0;
	msg.pReply		= box;

	pfsmail->PostMessage( &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CdrvUserFile::GetCreationTime( PTFILETIME pTime )
	{
	PCkeMailBox box = new CkeMailBox( NULL );

	TMSG msg;

	msg.dwMessage	= DRV_GETCREATIONTIME_FUB;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= (DWORD) pTime;
	msg.pReply		= box;

	pfsmail->PostMessage( &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CdrvUserFile::GetLastAccessTime( PTFILETIME pTime )
	{
	PCkeMailBox box = new CkeMailBox( NULL );

	TMSG msg;

	msg.dwMessage	= DRV_GETACCESSTIME_FUB;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= (DWORD) pTime;
	msg.pReply		= box;

	pfsmail->PostMessage( &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CdrvUserFile::GetLastWriteTime( PTFILETIME pTime )
	{
	PCkeMailBox box = new CkeMailBox( NULL );

	TMSG msg;

	msg.dwMessage	= DRV_GETWRITETIME_FUB;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= (DWORD) pTime;
	msg.pReply		= box;

	pfsmail->PostMessage( &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CdrvUserFile::GetCreationDate( PTFILEDATE pDate )
	{
	PCkeMailBox box = new CkeMailBox( NULL );

	TMSG msg;

	msg.dwMessage	= DRV_GETCREATIONDATE_FUB;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= (DWORD) pDate;
	msg.pReply		= box;

	pfsmail->PostMessage( &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CdrvUserFile::GetLastAccessDate( PTFILEDATE pDate )
	{
	PCkeMailBox box = new CkeMailBox( NULL );

	TMSG msg;

	msg.dwMessage	= DRV_GETACCESSDATE_FUB;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= (DWORD) pDate;
	msg.pReply		= box;

	pfsmail->PostMessage( &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CdrvUserFile::GetLastWriteDate( PTFILEDATE pDate )
	{
	PCkeMailBox box = new CkeMailBox( NULL );

	TMSG msg;

	msg.dwMessage	= DRV_GETWRITEDATE_FUB;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= (DWORD) pDate;
	msg.pReply		= box;

	pfsmail->PostMessage( &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CdrvUserFile::SetCreationTime( PTFILETIME pTime )
	{
	PCkeMailBox box = new CkeMailBox( NULL );

	TMSG msg;

	msg.dwMessage	= DRV_SETCREATIONTIME_FUB;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= (DWORD) pTime;
	msg.pReply		= box;

	pfsmail->PostMessage( &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CdrvUserFile::SetLastAccessTime( PTFILETIME pTime )
	{
	PCkeMailBox box = new CkeMailBox( NULL );

	TMSG msg;

	msg.dwMessage	= DRV_SETACCESSTIME_FUB;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= (DWORD) pTime;
	msg.pReply		= box;

	pfsmail->PostMessage( &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CdrvUserFile::SetLastWriteTime( PTFILETIME pTime )
	{
	PCkeMailBox box = new CkeMailBox( NULL );

	TMSG msg;

	msg.dwMessage	= DRV_SETWRITETIME_FUB;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= (DWORD) pTime;
	msg.pReply		= box;

	pfsmail->PostMessage( &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CdrvUserFile::SetCreationDate( PTFILEDATE pDate )
	{
	PCkeMailBox box = new CkeMailBox( NULL );

	TMSG msg;

	msg.dwMessage	= DRV_SETCREATIONDATE_FUB;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= (DWORD) pDate;
	msg.pReply		= box;

	pfsmail->PostMessage( &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CdrvUserFile::SetLastAccessDate( PTFILEDATE pDate )
	{
	PCkeMailBox box = new CkeMailBox( NULL );

	TMSG msg;

	msg.dwMessage	= DRV_SETACCESSDATE_FUB;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= (DWORD) pDate;
	msg.pReply		= box;

	pfsmail->PostMessage( &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CdrvUserFile::SetLastWriteDate( PTFILEDATE pDate )
	{
	PCkeMailBox box = new CkeMailBox( NULL );

	TMSG msg;

	msg.dwMessage	= DRV_SETWRITEDATE_FUB;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= (DWORD) pDate;
	msg.pReply		= box;

	pfsmail->PostMessage( &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CdrvUserFile::SetAttributes( DWORD dwAttributes )
	{
	PCkeMailBox box = new CkeMailBox( NULL );

	TMSG msg;

	msg.dwMessage	= DRV_SETATTRIBUTES_FUB;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= dwAttributes;
	msg.pReply		= box;

	pfsmail->PostMessage( &msg );

	box->WaitMessage( &msg );
	delete box;
	}

DWORD CdrvUserFile::GetAttributes()
	{
	PCkeMailBox box = new CkeMailBox( NULL );

	TMSG msg;

	msg.dwMessage	= DRV_GETATTRIBUTES_FUB;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 0;
	msg.pReply		= box;

	pfsmail->PostMessage( &msg );

	box->WaitMessage( &msg );
	delete box;

	return msg.dwParam1;
	}

PVOID CdrvUserFile::GetInternalPointer()
	{
	return pobject;
	}

DWORD CdrvUserFile::Status()
	{
	return dwstatus;
	}

