/* **************************************************************************
*                                                                           *
*  Keyb.CPP                                                                 *
*                                                                           *
*  14-02-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Controlador de teclat de l'Akula                                         *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "drivers\char\keyb.h"
#include "drivers\messages.h"
#include "kernel\mailbox.h"

CdrvKeyboard::CdrvKeyboard( PVOID pVideo ) : CdrvCharDevice( KEYBOARD_MAILBOX )
	{
	id = CID_KeyboardDriver;

	PCkeMailBox box = new CkeMailBox( NULL );

	TMSG msg;

	msg.dwMessage	= DRV_CREATEINSTANCE_KEY;
	msg.dwParam1	= (DWORD) pVideo;
	msg.dwParam2	= 0;
	msg.pReply		= box;

	pobject->PostMessage( &msg );

	box->WaitMessage( &msg );
	delete box;

	pkeyboardinstance = (PVOID) msg.dwParam1;
	}

CdrvKeyboard::~CdrvKeyboard()
	{
	PCkeMailBox box = new CkeMailBox( NULL );

	TMSG msg;

	msg.dwMessage	= DRV_DESTROYINSTANCE_KEY;
	msg.dwParam1	= (DWORD) pkeyboardinstance;
	msg.dwParam2	= 0;
	msg.pReply		= box;

	pobject->PostMessage( &msg );

	box->WaitMessage( &msg );
	delete box;
	}

DWORD CdrvKeyboard::GetChar()
	{
//	PCkeMailBox box = new CkeMailBox( NULL );
	CkeMailBox box( NULL );

	TMSG msg;

	msg.dwMessage	= DRV_GETCHAR_KEY;
	msg.dwParam1	= (DWORD) pkeyboardinstance;
	msg.dwParam2	= 0;
//	msg.pReply		= box;
	msg.pReply		= &box;

	pobject->PostMessage( &msg );

//	box->WaitMessage( &msg );
//	delete box;
	box.WaitMessage( &msg );
	
	return msg.dwParam1;
	}

DWORD CdrvKeyboard::CheckChar()
	{
	PCkeMailBox box = new CkeMailBox( NULL );

	TMSG msg;

	msg.dwMessage	= DRV_CHECKCHAR_KEY;
	msg.dwParam1	= (DWORD) pkeyboardinstance;
	msg.dwParam2	= 0;
	msg.pReply		= box;

	pobject->PostMessage( &msg );

	box->WaitMessage( &msg );
	delete box;

	return msg.dwParam1;
	}

VOID CdrvKeyboard::Activate()
	{
	PCkeMailBox box = new CkeMailBox( NULL );

	TMSG msg;

	msg.dwMessage	= DRV_ACTIVATE_KEY;
	msg.dwParam1	= (DWORD) pkeyboardinstance;
	msg.dwParam2	= 0;
	msg.pReply		= box;

	pobject->PostMessage( &msg );

	box->WaitMessage( &msg );
	delete box;
	}

PVOID CdrvKeyboard::GetInternalPointer()
	{
	return pkeyboardinstance;
	}

