/* **************************************************************************
*                                                                           *
*  Fenix.CPP                                                                *
*                                                                           *
*  03-04-97                                                    BUILD:0002   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ pconsentiment per escrit de l'autor.        *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Subsistema Fnix de l'Eros ver 1.00                                      *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "fenix\private\fenix.h"
#include "sys\mailbox.h"
#include "string.h"
#include "kernel\boxdef.h"
#include "sys\asm.h"
#include "sys\console.h"
#include "fenix\messages.h"

// *********************************** DEFINES
#ifdef _DEBUG
#define _VER	TEXT( "0.01" )
#else
#define _VER	TEXT( "1.00" )
#endif

#define _BUILD	2
#define VERSION	0x00010000

PCsysModule SYSModule = NULL; // Per a comunicar-nos amb SYS
PCsysConsole pcons; // Amb aquest objecte podrem enviar missatges cap a la pantalla
PVOID system; // Necessitem un apuntador cap a la bstia del sistema

BOOL DispatchMessage( TMSG& );

// Funci principal
void main()
	{
	SYSModule = new CsysModule; // Inicialitzem la classe que controla la comunicaci amb SYS

	pcons = new CsysConsole; // Obtenim una consola per a presentar missatges
	CHAR str[ 80 ];
	sprintf( str, TEXT( "Fenix  Subsystem ver %s (Build %3u) Date: %s\r\n" ), _VER, _BUILD, TEXT( __DATE__ ) );
	pcons->OutText( str );

	PVOID pparent = FindObject( MAILBOX_DIR ); // Obtenim el directori de les bsties

	if( !pparent ) // Si hi ha algun problema no podem continuar
		{
		pcons->OutText( TEXT( "FENIX - Error: no pot accedir a MAILBOX_DIR\r\n" ) );
		while( 1 )
			{}
		}

	system = FindObject( SYS_MAILBOX ); // Cerquem la bstia del sistema

	CsysMailBox box( pparent, nFENIX_MAILBOX ); // Creem la nostra prpia bstia global

	TMSG msg;

	// Executem l'intrpret de comandes
	if( !SYSModule->Exec( TEXT( "C:\\EROS\\BIN\\COMMAND.EXE" ) ) )
		pcons->OutText( TEXT( "Error intentant executar l'intrpret de comandes!\r\n" ) );

	while( TRUE ) // Esperem i tractem els missatges
		{
#ifdef _DEBUG
		pcons->OutText( TEXT( "FENIX - missatge rebut\r\n" ) );
#endif
		box.WaitMessage( &msg );
		DispatchMessage( msg );
		}
	}

// Tractem els missatges rebuts
BOOL DispatchMessage( TMSG &msg )
	{
	if( msg.dwMessage < DRV_GETNAME_DRIVER )
		PostMessage( system, &msg ); // Passem el missatge a SYS
	else
	if( msg.dwMessage == FNX_GETVERSION_MOD )
		{
		msg.dwParam1 = VERSION;
		PostMessage( msg.pReply, &msg ); // Retornem la versi del Fnix
		}
	else // Missatge erroni
		pcons->OutText( TEXT( "FENIX - ERROR en un missatge rebut\r\n" ) );

	return FALSE;
	}

