/* **************************************************************************
*                                                                           *
*  ASM.CPP                                                                  *
*                                                                           *
*  01-05-97                                                    BUILD:0003   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ pconsentiment per escrit de l'autor.        *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Rutines en codi mquina necessries per a la biblioteca                  *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "fenix\asm.h"
#include "kernel\intnum.h"
#include "kernel\callnum.h"

PVOID FindObject( PSTR sName )
	{
	asm mov eax, SYSCALL_FINDOBJECT
	asm mov ebx, sName
	asm int INT_SYSCALL

	return (PVOID) _EAX;
	}

PVOID CreateMailBox( PSTR sName, PVOID pParent )
	{
	asm push ecx
	asm mov eax, SYSCALL_CREATEMAILBOX
	asm mov ebx, sName
	asm mov ecx, pParent
	asm int INT_SYSCALL
	asm pop ecx

	return (PVOID) _EAX;
	}

VOID DestroyMailBox( PVOID pMailbox )
	{
	asm mov eax, SYSCALL_DESTROYMAILBOX
	asm mov ebx, pMailbox
	asm int INT_SYSCALL
	}

VOID PostMessage( PVOID pMailbox, PTMSG pMessage )
	{
	asm push ecx
	asm mov eax, SYSCALL_POSTMESSAGE
	asm mov ebx, pMailbox
	asm mov ecx, pMessage
	asm int INT_SYSCALL
	asm pop ecx
	}

BOOL WaitMessage( PVOID pMailbox, PTMSG pMessage )
	{
	asm push ecx
	asm mov eax, SYSCALL_WAITMESSAGE
	asm mov ebx, pMailbox
	asm mov ecx, pMessage
	asm int INT_SYSCALL
	asm pop ecx

	return (BOOL) _EAX;
	}

BOOL PeekMessage( PVOID pMailbox, PTMSG pMessage )
	{
	asm push ecx
	asm mov eax, SYSCALL_PEEKMESSAGE
	asm mov ebx, pMailbox
	asm mov ecx, pMessage
	asm int INT_SYSCALL
	asm pop ecx

	return (BOOL) _EAX;
	}

DWORD WaitingMessages( PVOID pMailbox )
	{
	asm mov eax, SYSCALL_WAITINGMESSAGES
	asm mov ebx, pMailbox
	asm int INT_SYSCALL

	return _EAX;
	}

PVOID GetInternalThread()
	{
	asm mov eax, SYSCALL_GETRUNNINGTHREAD
	asm int INT_SYSCALL

	return (PVOID) _EAX;
	}

PVOID malloc( DWORD dwSize )
	{
	asm mov eax, SYSCALL_MALLOC
	asm mov ebx, dwSize
	asm int INT_SYSCALL

	return (PVOID) _EAX;
	}

VOID free( PVOID pAddress )
	{
	asm mov eax, SYSCALL_FREE
	asm mov ebx, pAddress
	asm int INT_SYSCALL
	}

VOID WaitResource( PVOID pResource )
	{
	asm mov eax, SYSCALL_WAITRESOURCE
	asm mov ebx, pResource
	asm int INT_SYSCALL
	}

VOID ReleaseResource( PVOID pResource )
	{
	asm mov eax, SYSCALL_RELEASERESOURCE
	asm mov ebx, pResource
	asm int INT_SYSCALL
	}

