/* **************************************************************************
*                                                                           *
*  Callback.CPP                                                             *
*                                                                           *
*  08-03-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classe per a la gesti de les funcions de 'Callback'                     *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "fenix\callback.h"
#include "fenix\mailbox.h"
#include "fenix\asm.h"
#include "fenix\fenix.h"

CfnxCallback::CfnxCallback( PCfnxMailBox pMailBox, PCfnxObject pParent, PSTR sName ) : CfnxResource()
	{
	id = CID_Callback;

	if( pMailBox )
		Create( pMailBox, pParent, sName );
	}

CfnxCallback::~CfnxCallback()
	{
	if( id == CID_Callback )
		Destroy();
	}

BOOL CfnxCallback::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_Callback )
		return TRUE;
	else
		return CfnxResource::ClassCheck( Cuid );
	}

VOID CfnxCallback::Create( PCfnxMailBox pMailBox, PCfnxObject pParent, PSTR sName )
	{
	PCfnxMailBox box = new CfnxMailBox();

	TData data;
	data.dwParam1	= (DWORD) sName;
	data.dwParam2	= (DWORD) pMailBox->GetInternalPointer();

	TMSG msg;

	msg.dwMessage	= SYS_CREATE_CALLBACK;
	msg.dwParam1	= (DWORD) pParent;
	msg.dwParam2	= (DWORD) &data;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	pobject = (PVOID) msg.dwParam1;
	}

VOID CfnxCallback::Destroy()
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_DESTROY_CALLBACK;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

