/* **************************************************************************
*                                                                           *
*  CharDev.CPP                                                              *
*                                                                           *
*  10-02-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Base genrica per a tots els dispositius de carcters                    *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "fenix\chardev.h"
#include "fenix\messages.h"
#include "fenix\asm.h"

// **************************************************************************
// Prepara l'objecte
CfnxCharDevice::CfnxCharDevice( PSTR sName ) : CfnxDriver( sName )
	{
	id	= CID_CharacterDevice;
	}

CfnxCharDevice::~CfnxCharDevice()
	{
	}

BYTE CfnxCharDevice::ReadByte()
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= DRV_READBYTE_CHARDEV;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( pobject, &msg );

	box->WaitMessage( &msg );
	delete box;

	return (BYTE) msg.dwParam1;
	}

VOID CfnxCharDevice::WriteByte( BYTE cByte )
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= DRV_WRITEBYTE_CHARDEV;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= (DWORD) cByte;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( pobject, &msg );

	box->WaitMessage( &msg );
	delete box;
	}

