/* **************************************************************************
*                                                                           *
*  Console.CPP                                                              *
*                                                                           *
*  08-03-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Control de la pantalla                                                   *
*                                                                           *
************************************************************************** */

#include "fenix\console.h"
#include "errors.h"
#include "fenix\mailbox.h"
#include "fenix\asm.h"
#include "fenix\fenix.h"
#include "string.h"

extern PCfnxModule Spitfire;

// **************************************************************************
// Constructor de la classe
CfnxConsole::CfnxConsole() : CfnxType( CID_Console )
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_CREATE_CONSOLE;
	msg.dwParam1	= (DWORD) GetInternalThread();
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Spitfire->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
/*
	PWORD pant = (PWORD) 0xB8000;
	for( DWORD p = 0; p < 80; p++ )
		pant[ p ] = (WORD) ('i' | 0x700);
*/
	pconsole = (PVOID) msg.dwParam1;
	}

// **************************************************************************
// Destructor de la classe
CfnxConsole::~CfnxConsole()
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_DESTROY_CONSOLE;
	msg.dwParam1	= (DWORD) pconsole;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Spitfire->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

// **************************************************************************
// Indica si la classe de l'objecte es o no la que es passa com a parametre
// Com a entrada ha de rebre:
// Cuid     	- Identificador de la classe
BOOL CfnxConsole::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_Console )
		return TRUE;
	else
		return CfnxType::ClassCheck( Cuid );
	}

// **************************************************************************
// Escriu el text indicat per pantalla
// Com a entrada ha de rebre:
// str      	- Cadena de carcters a escriure
VOID CfnxConsole::OutText( PSTR str )
	{
	PSTR string = (PSTR) malloc( strlen( str ) + 1 );
	strcpy( string, str );

	TMSG msg;

	msg.dwMessage	= SYS_OUTTEXT_CONSOLE;
	msg.dwParam1	= (DWORD) pconsole;
	msg.dwParam2	= (DWORD) string;
	msg.pReply		= Spitfire->NULLMailBox();

	PostMessage( Spitfire->MailBox(), &msg );
	}

// **************************************************************************
// Selecciona la nova possici del cursor dins la pantalla
// Com a entrada ha de rebre:
// x        	- Columna desitjada
// y        	- Fila desitjada
VOID CfnxConsole::GotoXY( BYTE x, BYTE y )
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_GOTOXY_CONSOLE;
	msg.dwParam1	= (DWORD) pconsole;
	msg.dwParam2	= (DWORD) (x + ((DWORD) y << 8));
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Spitfire->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

// **************************************************************************
// Esborra la pantalla pintant-la amb gris sobre negre
VOID CfnxConsole::Clear()
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_CLEAR_CONSOLE;
	msg.dwParam1	= (DWORD) pconsole;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Spitfire->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

