/* **************************************************************************
*                                                                           *
*  Debug.CPP                                                                *
*                                                                           *
*  08-03-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classe per a ajudar a la depuraci del sistema i dels programes          *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "fenix\debug.h"
#include "errors.h"
#include "fenix\mailbox.h"
#include "fenix\asm.h"
#include "fenix\fenix.h"

// **************************************************************************
// Prepara l'objecte
CfnxDebug::CfnxDebug() : CfnxType( CID_Debug )
	{
	}

// **************************************************************************
// Destructor de l'objecte
CfnxDebug::~CfnxDebug()
	{
	}

// **************************************************************************
// Indica si la classe de l'objecte es o no la que es passa com a parametre
// Com a entrada ha de rebre:
// Cuid     	- Identificador de la classe
BOOL CfnxDebug::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_Debug )
		return TRUE;
	else
		return CfnxType::ClassCheck( Cuid );
	}

// **************************************************************************
// Realitza la comprovaci de tipus en temps d'execuci
// Com a entrada ha de rebre:
// Type     	- Objecte sobre el qual es fa la comprovaci
// id       	- Identificador esperat
// Error    	- Cadena de caracters que s'ha d'enviar en cas d'error
VOID CfnxDebug::CheckPanic( PCfnxType pType, CUID id, PSTR sError )
	{
	if( pType->ClassID() != id )
		Trace( sError );
// Hauria d'aturar l'execuci? -BUG
	}

// **************************************************************************
// Realitza la funcio de traa
// Com a entrada ha de rebre:
// str      	- Cadena de caracters que s'ha d'enviar
VOID CfnxDebug::Trace( PSTR str )
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_TRACE_DEBUG;
	msg.dwParam1	= (DWORD) str;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CfnxDebug::MemoryDump( PBYTE pAddress, DWORD dwSize )
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_MEMORYDUMP_DEBUG;
	msg.dwParam1	= (DWORD) pAddress;
	msg.dwParam2	= dwSize;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

