/* **************************************************************************
*                                                                           *
*  Driver.CPP                                                               *
*                                                                           *
*  12-03-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Base genrica per a qualsevol controlador de dispositiu                  *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "fenix\driver.h"
#include "fenix\messages.h"
#include "fenix\mailbox.h"
#include "fenix\asm.h"

CfnxDriver::CfnxDriver( PSTR sName ) : CfnxType( CID_Driver )
	{
	pobject = FindObject( sName );
	}

CfnxDriver::~CfnxDriver()
	{
	}

VOID CfnxDriver::DriverName( PSTR sName, DWORD dwMaxSize )
	{
	PCfnxMailBox box = new CfnxMailBox();

	TData data;
	data.dwParam1 = (DWORD) sName;
	data.dwParam2 = dwMaxSize;

	TMSG msg;

	msg.dwMessage	= DRV_GETNAME_DRIVER;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= (DWORD) &data;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( pobject, &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CfnxDriver::DeviceName( PSTR sName, DWORD dwMaxSize )
	{
	PCfnxMailBox box = new CfnxMailBox();

	TData data;
	data.dwParam1 = (DWORD) sName;
	data.dwParam2 = dwMaxSize;

	TMSG msg;

	msg.dwMessage	= DRV_GETDEVICENAME_DRIVER;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= (DWORD) &data;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( pobject, &msg );

	box->WaitMessage( &msg );
	delete box;
	}

BYTE CfnxDriver::Version()
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= DRV_GETVERSION_DRIVER;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( pobject, &msg );

	box->WaitMessage( &msg );
	delete box;

	return (BYTE) msg.dwParam1;
	}

BYTE CfnxDriver::Level()
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= DRV_GETLEVEL_DRIVER;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( pobject, &msg );

	box->WaitMessage( &msg );
	delete box;

	return (BYTE) msg.dwParam1;
	}

PVOID CfnxDriver::MailBox()
	{
	return pobject;
	}
// -BUG
VOID CfnxDriver::IOCtl( DWORD, DWORD )
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= DRV_IOCTL_DRIVER;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( pobject, &msg );

	box->WaitMessage( &msg );
	delete box;
	}

BOOL CfnxDriver::IsLocal()
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= DRV_ISLOCAL_DEVICE;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( pobject, &msg );

	box->WaitMessage( &msg );
	delete box;

	return (BOOL) msg.dwParam1;
	}

BOOL CfnxDriver::IsRemovable()
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= DRV_ISREMOVABLE_DEVICE;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( pobject, &msg );

	box->WaitMessage( &msg );
	delete box;

	return (BOOL) msg.dwParam1;
	}

BOOL CfnxDriver::HasMedia()
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= DRV_HASMEDIA_DEVICE;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( pobject, &msg );

	box->WaitMessage( &msg );
	delete box;

	return (BOOL) msg.dwParam1;
	}

DWORD CfnxDriver::CheckMedia()
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= DRV_CHECKMEDIA_DEVICE;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( pobject, &msg );

	box->WaitMessage( &msg );
	delete box;

	return msg.dwParam1;
	}

BOOL CfnxDriver::IsExclusive()
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= DRV_ISEXCLUSIVE_DEVICE;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( pobject, &msg );

	box->WaitMessage( &msg );
	delete box;

	return (BOOL) msg.dwParam1;
	}

VOID CfnxDriver::Lock()
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= DRV_LOCK_DEVICE;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 1;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( pobject, &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CfnxDriver::Unlock()
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= DRV_LOCK_DEVICE;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( pobject, &msg );

	box->WaitMessage( &msg );
	delete box;
	}

DWORD CfnxDriver::Read( DWORD dwSource, DWORD dwSize )
	{
	PCfnxMailBox box = new CfnxMailBox();

	TData data;

	data.dwParam1	= dwSource;
	data.dwParam2	= dwSize;

	TMSG msg;

	msg.dwMessage	= DRV_READ_DRIVER;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= (DWORD) &data;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( pobject, &msg );

	box->WaitMessage( &msg );
	delete box;

	return msg.dwParam1;
	}

DWORD CfnxDriver::Write( DWORD dwDestination, DWORD dwSize )
	{
	PCfnxMailBox box = new CfnxMailBox();

	TData data;

	data.dwParam1	= dwDestination;
	data.dwParam2	= dwSize;

	TMSG msg;

	msg.dwMessage	= DRV_WRITE_DRIVER;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= (DWORD) &data;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( pobject, &msg );

	box->WaitMessage( &msg );
	delete box;

	return msg.dwParam1;
	}

DWORD CfnxDriver::Status()
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= DRV_GETSTATUS_DRIVER;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( pobject, &msg );

	box->WaitMessage( &msg );
	delete box;

	return msg.dwParam1;
	}

