/* **************************************************************************
*                                                                           *
*  Fenix.CPP                                                                *
*                                                                           *
*  11-03-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ pconsentiment per escrit de l'autor.        *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Subsistema Fenix ver 0.01 - biblioteca de crides al subsistema           *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "fenix\fenix.h"
#include "fenix\messages.h"
#include "fenix\mailbox.h"
#include "fenix\timer.h"
#include "fenix\asm.h"
#include "string.h"
#include "errors.h"

CfnxModule::CfnxModule()
	{
	pbox = FindObject( FENIX_MAILBOX );
	pnullbox = CreateMailBox( NULL, NULL );
	}

CfnxModule::~CfnxModule()
	{
	}

PVOID CfnxModule::MailBox()
	{
	return pbox;
	}

PVOID CfnxModule::NULLMailBox()
	{
	return pnullbox;
	}

VOID CfnxModule::GetComputerName( PSTR sName, DWORD dwMaxSize )
	{
	PCfnxMailBox preply = new CfnxMailBox();
	TMSG msg;

	msg.dwMessage	= SYS_GETCOMPUTERNAME_MOD;
	msg.dwParam1	= (DWORD) sName;
	msg.dwParam2	= dwMaxSize;
	msg.pReply		= (PVOID) preply->GetInternalPointer();

	PostMessage( pbox, &msg );

	TMSG msg2;

	preply->WaitMessage( &msg2 );
	delete preply;
	}

TTIME CfnxModule::GetTime()
	{
	PCfnxMailBox preply = new CfnxMailBox();
	TMSG msg;

	msg.dwMessage	= SYS_GETTIME_MOD;
	msg.dwParam1	= 0;
	msg.dwParam2	= 0;
	msg.pReply		= preply->GetInternalPointer();

	PostMessage( pbox, &msg );

	preply->WaitMessage( &msg );
	delete preply;

	TTIME time;
	time.dwAll = msg.dwParam1;

	return time;
	}

TDATE CfnxModule::GetDate()
	{
	PCfnxMailBox preply = new CfnxMailBox();
	TMSG msg;

	msg.dwMessage	= SYS_GETDATE_MOD;
	msg.dwParam1	= 0;
	msg.dwParam2	= 0;
	msg.pReply		= preply->GetInternalPointer();

	PostMessage( pbox, &msg );

	preply->WaitMessage( &msg );
	delete preply;

	TDATE date;
	date.dwAll = msg.dwParam1;

	return date;
	}

VOID CfnxModule::SetTime( TTIME Time )
	{
	PCfnxMailBox preply = new CfnxMailBox();
	TMSG msg;

	msg.dwMessage	= SYS_SETTIME_MOD;
	msg.dwParam1	= Time.dwAll;
	msg.dwParam2	= 0;
	msg.pReply		= preply->GetInternalPointer();

	PostMessage( pbox, &msg );

	preply->WaitMessage( &msg );
	delete preply;
	}

VOID CfnxModule::SetDate( TDATE Date )
	{
	PCfnxMailBox preply = new CfnxMailBox();
	TMSG msg;

	msg.dwMessage	= SYS_SETDATE_MOD;
	msg.dwParam1	= Date.dwAll;
	msg.dwParam2	= 0;
	msg.pReply		= preply->GetInternalPointer();

	PostMessage( pbox, &msg );

	preply->WaitMessage( &msg );
	delete preply;
	}

VOID CfnxModule::RegisterShutdown( PVOID pAddress )
	{
	PCfnxMailBox preply = new CfnxMailBox();
	TMSG msg;

	msg.dwMessage	= SYS_REGISTERSHUTDOWN_MOD;
	msg.dwParam1	= (DWORD) pAddress;
	msg.dwParam2	= 0;
	msg.pReply		= preply->GetInternalPointer();

	PostMessage( pbox, &msg );

	preply->WaitMessage( &msg );
	delete preply;
	}

VOID CfnxModule::UnregisterShutdown( PVOID pAddress )
	{
	PCfnxMailBox preply = new CfnxMailBox();
	TMSG msg;

	msg.dwMessage	= SYS_UNREGISTERSHUTDOWN_MOD;
	msg.dwParam1	= (DWORD) pAddress;
	msg.dwParam2	= 0;
	msg.pReply		= preply->GetInternalPointer();

	PostMessage( pbox, &msg );

	preply->WaitMessage( &msg );
	delete preply;
	}

VOID CfnxModule::Shutdown( DWORD dwMode )
	{
	PCfnxMailBox preply = new CfnxMailBox();
	TMSG msg;

	msg.dwMessage	= SYS_SHUTDOWN_MOD;
	msg.dwParam1	= dwMode;
	msg.dwParam2	= 0;
	msg.pReply		= preply->GetInternalPointer();

	PostMessage( pbox, &msg );

	preply->WaitMessage( &msg );
	delete preply;
	}

VOID CfnxModule::MemCopy( PBYTE pDest, PBYTE pSource, DWORD dwSize )
	{
	PCfnxMailBox preply = new CfnxMailBox();
	TMSG msg;

	TData data;
	data.dwParam1 = (DWORD) pDest;
	data.dwParam2 = (DWORD) pSource;
	data.dwParam3 = dwSize;

	msg.dwMessage	= SYS_MEMCOPY_MOD;
	msg.dwParam1	= (DWORD) &data;
	msg.dwParam2	= 0;
	msg.pReply		= preply->GetInternalPointer();

	PostMessage( pbox, &msg );

	preply->WaitMessage( &msg );
	delete preply;
	}

VOID CfnxModule::MemMove( PBYTE pDest, PBYTE pSource, DWORD dwSize )
	{
	PCfnxMailBox preply = new CfnxMailBox();
	TMSG msg;

	TData data;
	data.dwParam1 = (DWORD) pDest;
	data.dwParam2 = (DWORD) pSource;
	data.dwParam3 = dwSize;

	msg.dwMessage	= SYS_MEMMOVE_MOD;
	msg.dwParam1	= (DWORD) &data;
	msg.dwParam2	= 0;
	msg.pReply		= preply->GetInternalPointer();

	PostMessage( pbox, &msg );

	preply->WaitMessage( &msg );
	delete preply;
	}

VOID CfnxModule::MemSet( PBYTE pAddress, DWORD dwSize, BYTE cValue )
	{
	PCfnxMailBox preply = new CfnxMailBox();
	TMSG msg;

	TData data;
	data.dwParam1 = (DWORD) pAddress;
	data.dwParam2 = dwSize;
	data.dwParam3 = (DWORD) cValue;

	msg.dwMessage	= SYS_MEMSET_MOD;
	msg.dwParam1	= (DWORD) &data;
	msg.dwParam2	= 0;
	msg.pReply		= preply->GetInternalPointer();

	PostMessage( pbox, &msg );

	preply->WaitMessage( &msg );
	delete preply;
	}

LONG CfnxModule::MemCompare( PBYTE pSource1, PBYTE pSource2, DWORD dwSize )
	{
	PCfnxMailBox preply = new CfnxMailBox();
	TMSG msg;

	TData data;
	data.dwParam1 = (DWORD) pSource1;
	data.dwParam2 = (DWORD) pSource2;
	data.dwParam3 = dwSize;

	msg.dwMessage	= SYS_MEMCOMPARE_MOD;
	msg.dwParam1	= (DWORD) &data;
	msg.dwParam2	= 0;
	msg.pReply		= preply->GetInternalPointer();

	PostMessage( pbox, &msg );

	preply->WaitMessage( &msg );
	delete preply;

	return msg.dwParam1;
	}

DWORD CfnxModule::ErrorCode()
	{
	PCfnxMailBox preply = new CfnxMailBox();
	TMSG msg;

	msg.dwMessage	= SYS_GETERRORCODE_THREAD;
	msg.dwParam1	= (DWORD) GetInternalThread();
	msg.dwParam2	= 0;
	msg.pReply		= preply->GetInternalPointer();

	PostMessage( pbox, &msg );

	preply->WaitMessage( &msg );
	delete preply;

	return msg.dwParam1;
	}

VOID CfnxModule::Sleep( DWORD dwms )
	{
	PCfnxMailBox preply = new CfnxMailBox();
	TMSG msg;

	PCfnxTimer alarm = new CfnxTimer( dwms, preply, NULL );

	preply->WaitMessage( &msg );
	delete alarm;
	delete preply;
	}

PCfnxThread CfnxModule::CreateThread( DWORD dwEntryPoint, DWORD dwStackReserve, DWORD dwStackCommit )
	{
	PCfnxMailBox preply = new CfnxMailBox();

	TData data;

	data.dwParam1	= dwStackReserve;
	data.dwParam2	= dwStackCommit;

	TMSG msg;

	msg.dwMessage	= SYS_CREATE_THREAD;
	msg.dwParam1	= (DWORD) dwEntryPoint;
	msg.dwParam2	= (DWORD) &data;
	msg.pReply		= preply->GetInternalPointer();

	PostMessage( pbox, &msg );

	preply->WaitMessage( &msg );
	delete preply;

	return new CfnxThread( (PVOID) msg.dwParam1 );
	}

BOOL CfnxModule::Exec( PSTR sName )
	{
	PCfnxMailBox preply = new CfnxMailBox();
	TMSG msg;

	msg.dwMessage	= SYS_EXEC_MOD;
	msg.dwParam1	= (DWORD) sName;
	msg.dwParam2	= 0;
	msg.pReply		= preply->GetInternalPointer();

	PostMessage( pbox, &msg );

	preply->WaitMessage( &msg );
	delete preply;

	return (BOOL) msg.dwParam1;
	}

PCfnxThread CfnxModule::GetMe()
	{
	return NULL;
	}

PCfnxProcess CfnxModule::GetMyProcess()
	{
	return NULL;
	}

