/* **************************************************************************
*                                                                           *
*  Keyb.CPP                                                                 *
*                                                                           *
*  12-03-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Controlador de teclat de l'Spitfire                                      *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "fenix\keyb.h"
#include "fenix\messages.h"
#include "fenix\mailbox.h"
#include "fenix\asm.h"

CfnxKeyboard::CfnxKeyboard( PVOID pVideo ) : CfnxCharDevice( KEYBOARD_MAILBOX )
	{
	id = CID_KeyboardDriver;

	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= DRV_CREATEINSTANCE_KEY;
	msg.dwParam1	= (DWORD) pVideo;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( pobject, &msg );

	box->WaitMessage( &msg );
	delete box;

	pkeyboardinstance = (PVOID) msg.dwParam1;
	}

CfnxKeyboard::~CfnxKeyboard()
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= DRV_DESTROYINSTANCE_KEY;
	msg.dwParam1	= (DWORD) pkeyboardinstance;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( pobject, &msg );

	box->WaitMessage( &msg );
	delete box;
	}

DWORD CfnxKeyboard::GetChar()
	{
//	PCfnxMailBox box = new CfnxMailBox( NULL );
	CfnxMailBox box;

	TMSG msg;

	msg.dwMessage	= DRV_GETCHAR_KEY;
	msg.dwParam1	= (DWORD) pkeyboardinstance;
	msg.dwParam2	= 0;
//	msg.pReply		= box;
	msg.pReply		= box.GetInternalPointer();

	PostMessage( pobject, &msg );

//	box->WaitMessage( &msg );
//	delete box;
	box.WaitMessage( &msg );
	
	return msg.dwParam1;
	}

DWORD CfnxKeyboard::CheckChar()
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= DRV_CHECKCHAR_KEY;
	msg.dwParam1	= (DWORD) pkeyboardinstance;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( pobject, &msg );

	box->WaitMessage( &msg );
	delete box;

	return msg.dwParam1;
	}

VOID CfnxKeyboard::Activate()
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= DRV_ACTIVATE_KEY;
	msg.dwParam1	= (DWORD) pkeyboardinstance;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( pobject, &msg );

	box->WaitMessage( &msg );
	delete box;
	}

PVOID CfnxKeyboard::GetInternalPointer()
	{
	return pkeyboardinstance;
	}

