/* **************************************************************************
*                                                                           *
*  List.CPP                                                                 *
*                                                                           *
*  08-03-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classes genriques per a llistes i llistes doblement encadenades         *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "fenix\list.h"
#include "errors.h"
#include "fenix\fenix.h"

// **************************************************************************
// Constructor de la classe
// Com a entrada ha de rebre:
// next     	- Apunta a l'element seguent de la llista
CfnxListItem::CfnxListItem( PCfnxListItem next ) : CfnxType( CID_ListItem )
	{
	SetNext( next );
	}

// **************************************************************************
// Destrueix l'objecte
CfnxListItem::~CfnxListItem()
	{
// Hauriem de treure'l de la llista -BUG
	}

// **************************************************************************
// Indica si la classe de l'objecte es o no la que es passa com a parametre
// Com a entrada ha de rebre:
// Cuid     	- Identificador de la classe
BOOL CfnxListItem::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_ListItem )
		return TRUE;
	else
		return CfnxType::ClassCheck( Cuid );
	}

// **************************************************************************
// Retorna l'objecte seguent de la llista
PCfnxListItem CfnxListItem::GetNext()
	{
	return pnext;
	}

// **************************************************************************
// Selecciona l'objecte seguent de la llista
// Com a entrada ha de rebre:
// next     	- Apuntador al nou objecte seguent
void CfnxListItem::SetNext( PCfnxListItem next )
	{
	pnext			= next;
	}

// **************************************************************************
// Constructor de la classe
// Com a entrada ha de rebre:
// prev     	- Objecte anterior
// next     	- Objecte seguent
CfnxDblListItem::CfnxDblListItem( PCfnxDblListItem prev, PCfnxDblListItem next ) : CfnxListItem( (PCfnxListItem) next )
	{
//	TRACE( TEXT( "CfnxDblListItem::CfnxDblListItem" ) );

	id	= CID_DblListItem;
	SetPrev( prev );
	}

// **************************************************************************
// Destrueix l'objecte
CfnxDblListItem::~CfnxDblListItem()
	{
	// Primer l'hem de treure de la llista? -BUG
	}

// **************************************************************************
// Indica si la classe de l'objecte es o no la que es passa com a parametre
// Com a entrada ha de rebre:
// Cuid     	- Identificador de la classe
BOOL CfnxDblListItem::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_DblListItem )
		return TRUE;
	else
		return CfnxListItem::ClassCheck( Cuid );
	}

// **************************************************************************
// Retorna l'objecte anterior de la llista
PCfnxDblListItem CfnxDblListItem::GetPrev()
	{
	return pprev;
	}

// **************************************************************************
// Selecciona un nou objecte anterior
// Com a entrada ha de rebre:
// prev     	- Objecte que sera el nou anterior
void CfnxDblListItem::SetPrev( CfnxDblListItem *prev )
	{
	pprev			= prev;
	}

CfnxLIFOList::CfnxLIFOList() : CfnxType( CID_LIFOList )
	{
	pfirst = NULL;
	dwelements = 0L;
	}

CfnxLIFOList::~CfnxLIFOList()
	{
// Hem d'esborrar tots els elements? -BUG
	}

PCfnxListItem CfnxLIFOList::Get()
	{
	return pfirst;
	}

VOID CfnxLIFOList::Add( PCfnxListItem pItem )
	{
	dwelements++;
	pItem->SetNext( pfirst );

	if( pfirst )
		{
		if( pfirst->ClassCheck( CID_DblListItem ) )
			((PCfnxDblListItem) pfirst)->SetPrev( (PCfnxDblListItem) pItem );
		}

	pfirst = pItem;
	}

VOID CfnxLIFOList::Delete( PCfnxListItem pItem )
	{
	if( pfirst )
		{
		if( pfirst == pItem )
			{
			pfirst = pItem->GetNext();

			if( pfirst && pfirst->ClassCheck( CID_DblListItem ) )
				((PCfnxDblListItem) pfirst)->SetPrev( NULL );
			}
		else
		if( pItem->ClassCheck( CID_DblListItem ) )
			{
			PCfnxListItem pelem = ((PCfnxDblListItem) pItem)->GetPrev();

			pelem->SetNext( pItem->GetNext() );
			if( pItem->GetNext() )
				((PCfnxDblListItem) pItem->GetNext())->SetPrev( (PCfnxDblListItem) pelem );
			}
		else
			{
			PCfnxListItem pelem = pfirst;

			while( pelem->GetNext() != pItem && pelem->GetNext() )
				pelem = pelem->GetNext();

			if( pelem->GetNext() == pItem )
				pelem->SetNext( pItem->GetNext() );
			}

		dwelements--;
		}
	}

CfnxFIFOList::CfnxFIFOList() : CfnxLIFOList()
	{
	id	= CID_FIFOList;
	plast = NULL;
	}

CfnxFIFOList::~CfnxFIFOList()
	{
// Hem d'esborrar tots els elements -BUG
	}

PCfnxListItem CfnxFIFOList::Get()
	{
	return pfirst;
	}

VOID CfnxFIFOList::Add( PCfnxListItem pItem )
	{
	pItem->SetNext( NULL ); // Per si no s'ha fet -BUG
	dwelements++;

	if( plast )
		plast->SetNext( pItem );
	else
		pfirst = pItem;

	if( pItem->ClassCheck( CID_DblListItem ) )
		((PCfnxDblListItem) pItem)->SetPrev( (PCfnxDblListItem) plast );

	plast = pItem;
	}

VOID CfnxFIFOList::Delete( PCfnxListItem pItem )
	{
	if( pfirst )
		{
		if( pfirst == pItem )
			{
			pfirst = pItem->GetNext();

			if( pfirst->ClassCheck( CID_DblListItem ) )
				((PCfnxDblListItem) pfirst)->SetPrev( NULL );
			}
		else
		if( pItem->ClassCheck( CID_DblListItem ) )
			{
			(((PCfnxDblListItem) pItem)->GetPrev())->SetNext( pItem->GetNext() );
			((PCfnxDblListItem) pItem->GetNext())->SetPrev( ((PCfnxDblListItem) pItem)->GetPrev() );
			}
		else
			{
			PCfnxListItem pelem = pfirst;

			while( pelem->GetNext() != pItem && pelem->GetNext() )
				pelem = pelem->GetNext();

			if( pelem->GetNext() == pItem )
				{
				pelem->SetNext( pItem->GetNext() );

				if( pItem == plast )
					plast = pelem;
				}
			}

		dwelements--;
		}
	}

