/* **************************************************************************
*                                                                           *
*  Object.CPP                                                               *
*                                                                           *
*  08-03-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classe genrica per al control dels recursos i el directori d'objectes   *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "fenix\object.h"
#include "errors.h"
#include "string.h"
#include "fenix\mem.h"
#include "fenix\mailbox.h"
#include "fenix\asm.h"
#include "fenix\fenix.h"
#include "fenix\thread.h"

// **************************************************************************
// Constructor de la classe
// Com a entrada ha de rebre:
// Name 	   	- Nom de l'objecte (pot ser NULL)
// Temp  	  	- Indica si es temporal
CfnxObject::CfnxObject( PVOID pObject ) : CfnxDblListItem( NULL, NULL )
	{
	pobject = pObject;
	}

// **************************************************************************
// Destrueix l'objecte
CfnxObject::~CfnxObject()
	{
	}

// **************************************************************************
// Indica si la classe de l'objecte es o no la que es passa com a parametre
// Com a entrada ha de rebre:
// Cuid     	- Identificador de la classe
BOOL CfnxObject::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_Object )
		return TRUE;
	else
		return CfnxDblListItem::ClassCheck( Cuid );
	}

PVOID CfnxObject::GetInternalPointer()
	{
	return pobject;
	}

PCfnxThread CfnxObject::Creator()
	{
	CfnxMailBox box;

	TMSG msg;

	msg.dwMessage	= SYS_GETCREATOR_OBJECT;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 0;
	msg.pReply		= box.GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box.WaitMessage( &msg );

	return new CfnxThread( (PVOID) msg.dwParam1 );
	}

// **************************************************************************
// Retorna l'adrea de l'objecte despres d'obrir un apuntador cap a ell
// Com a entrada ha de rebre:
// Interrupt	- Identifica la interrupcio en la que es vol registrar
// Address  	- Indica l'adrea de memoria de la RSI
PCfnxObject CfnxObject::Enter()
	{
	CfnxMailBox box;

	TMSG msg;

	msg.dwMessage	= SYS_ENTER_OBJECT;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 0;
	msg.pReply		= box.GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box.WaitMessage( &msg );

	return this;
	}

// **************************************************************************
// Tanca un apuntador cap a l'objecte
VOID CfnxObject::Leave()
	{
	CfnxMailBox box;

	TMSG msg;

	msg.dwMessage	= SYS_LEAVE_OBJECT;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 0;
	msg.pReply		= box.GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box.WaitMessage( &msg );
	}

// **************************************************************************
// Retorna el nom de l'objecte
VOID CfnxObject::Name( PSTR sName, DWORD dwSize )
	{
	CfnxMailBox box;

	TData data;
	data.dwParam1	= (DWORD) sName;
	data.dwParam2	= dwSize;

	TMSG msg;

	msg.dwMessage	= SYS_GETNAME_OBJECT;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= (DWORD) &data;
	msg.pReply		= box.GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box.WaitMessage( &msg );
	}

// **************************************************************************
// Retorna el valor del comptador d'apuntadors oberts a l'objecte
DWORD CfnxObject::UseCount()
	{
	CfnxMailBox box;

	TMSG msg;

	msg.dwMessage	= SYS_GETUSECOUNT_OBJECT;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 0;
	msg.pReply		= box.GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box.WaitMessage( &msg );

	return msg.dwParam1;
	}

// **************************************************************************
// Retorna l'indicador de temporal
BOOL CfnxObject::Temporal()
	{
	CfnxMailBox box;

	TMSG msg;

	msg.dwMessage	= SYS_GETTEMPORAL_OBJECT;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 0;
	msg.pReply		= box.GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box.WaitMessage( &msg );

	return (BOOL) msg.dwParam1;
	}

// **************************************************************************
// Realitza la funci d'anlisi de la cadena de carcters
// Com a entrada ha de rebre:
// str      	- Cadena de carcters sobre la qual es realitza l'anlisi
PCfnxObject CfnxObject::Analysis( PSTR )
	{
// Per defecte noms es retorna l'objecte
	return this;
	}

