/* **************************************************************************
*                                                                           *
*  Rights.CPP                                                               *
*                                                                           *
*  08-03-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classe genrica per als drets adquirits i la llista de control d'accs   *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "fenix\rights.h"
#include "fenix\mailbox.h"
#include "fenix\asm.h"
#include "fenix\fenix.h"

CfnxRights::CfnxRights( PVOID pRights ) : CfnxType( CID_Rights )
	{
	prights = pRights;
	}

CfnxRights::~CfnxRights()
	{
	}

// **************************************************************************
// Indica si la classe de l'objecte es o no la que es passa com a parametre
// Com a entrada ha de rebre:
// Cuid     	- Identificador de la classe
BOOL CfnxRights::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_Rights )
		return TRUE;
	else
		return CfnxType::ClassCheck( Cuid );
	}

BOOL CfnxRights::Read()
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_GETREAD_RIGHTS;
	msg.dwParam1	= (DWORD) prights;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	return (BOOL) msg.dwParam1;
	}

BOOL CfnxRights::Write()
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_GETWRITE_RIGHTS;
	msg.dwParam1	= (DWORD) prights;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	return (BOOL) msg.dwParam1;
	}

BOOL CfnxRights::Execute()
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_GETEXECUTE_RIGHTS;
	msg.dwParam1	= (DWORD) prights;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	return (BOOL) msg.dwParam1;
	}

BOOL CfnxRights::Delete()
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_GETDELETE_RIGHTS;
	msg.dwParam1	= (DWORD) prights;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	return (BOOL) msg.dwParam1;
	}

BOOL CfnxRights::Syncronize()
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_GETSYNCRONIZE_RIGHTS;
	msg.dwParam1	= (DWORD) prights;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	return (BOOL) msg.dwParam1;
	}

BOOL CfnxRights::ModifyRights()
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_GETMODIFYRIGHTS_RIGHTS;
	msg.dwParam1	= (DWORD) prights;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	return (BOOL) msg.dwParam1;
	}

BOOL CfnxRights::ModifyState()
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_GETMODIFYSTATE_RIGHTS;
	msg.dwParam1	= (DWORD) prights;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	return (BOOL) msg.dwParam1;
	}

VOID CfnxRights::Read( BOOL bState )
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_SETREAD_RIGHTS;
	msg.dwParam1	= (DWORD) prights;
	msg.dwParam2	= (DWORD) bState;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CfnxRights::Write( BOOL bState )
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_SETWRITE_RIGHTS;
	msg.dwParam1	= (DWORD) prights;
	msg.dwParam2	= (DWORD) bState;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CfnxRights::Execute( BOOL bState )
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_SETEXECUTE_RIGHTS;
	msg.dwParam1	= (DWORD) prights;
	msg.dwParam2	= (DWORD) bState;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CfnxRights::Delete( BOOL bState )
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_SETDELETE_RIGHTS;
	msg.dwParam1	= (DWORD) prights;
	msg.dwParam2	= (DWORD) bState;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CfnxRights::Syncronize( BOOL bState )
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_SETSYNCRONIZE_RIGHTS;
	msg.dwParam1	= (DWORD) prights;
	msg.dwParam2	= (DWORD) bState;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CfnxRights::ModifyRights( BOOL bState )
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_SETMODIFYRIGHTS_RIGHTS;
	msg.dwParam1	= (DWORD) prights;
	msg.dwParam2	= (DWORD) bState;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CfnxRights::ModifyState( BOOL bState )
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_SETMODIFYSTATE_RIGHTS;
	msg.dwParam1	= (DWORD) prights;
	msg.dwParam2	= (DWORD) bState;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

