/* **************************************************************************
*                                                                           *
*  Security.CPP                                                             *
*                                                                           *
*  08-03-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classe que implementa les llistes de control d'accs (ACL)               *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "fenix\security.h"
#include "fenix\mailbox.h"
#include "fenix\asm.h"
#include "fenix\fenix.h"

CfnxSecurityItem::CfnxSecurityItem( PVOID pItem ) : CfnxDblListItem( NULL, NULL ), CfnxRights( pItem )
	{
	id = CID_SecurityItem;
	}

CfnxSecurityItem::~CfnxSecurityItem()
	{
	}

// **************************************************************************
// Indica si la classe de l'objecte es o no la que es passa com a parametre
// Com a entrada ha de rebre:
// Cuid     	- Identificador de la classe
BOOL CfnxSecurityItem::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_SecurityItem )
		return TRUE;
	else
		return CfnxDblListItem::ClassCheck( Cuid ) | CfnxRights::ClassCheck( Cuid );
	}

BYTE CfnxSecurityItem::Type()
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_GETTYPE_ACL;
	msg.dwParam1	= (DWORD) prights;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	return (BYTE) msg.dwParam1;
	}

