/* **************************************************************************
*                                                                           *
*  User.CPP                                                                 *
*                                                                           *
*  08-03-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classe de seguretat per a cada usuari individual                         *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "fenix\user.h"
#include "string.h"
#include "fenix\mailbox.h"
#include "fenix\asm.h"
#include "fenix\fenix.h"

CfnxUser::CfnxUser( PVOID pUser ) : CfnxAccessToken( pUser )
	{
	}

CfnxUser::~CfnxUser()
	{
	}

// **************************************************************************
// Indica si la classe de l'objecte es o no la que es passa com a parametre
// Com a entrada ha de rebre:
// Cuid     	- Identificador de la classe
BOOL CfnxUser::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_User )
		return TRUE;
	else
		return CfnxAccessToken::ClassCheck( Cuid );
	}

BOOL CfnxUser::CheckPassword( PSTR sPassword )
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_CHECKPASSWORD_USER;
	msg.dwParam1	= (DWORD) paccesstoken;
	msg.dwParam2	= (DWORD) sPassword;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	return (BOOL) msg.dwParam1;
	}

VOID CfnxUser::NewPassword( PSTR sOldPassword, PSTR sNewPassword )
	{
	PCfnxMailBox box = new CfnxMailBox();

	TData data;
	data.dwParam1 = (DWORD) sOldPassword;
	data.dwParam2 = (DWORD) sNewPassword;

	TMSG msg;

	msg.dwMessage	= SYS_SETPASSWORD_USER;
	msg.dwParam1	= (DWORD) paccesstoken;
	msg.dwParam2	= (DWORD) &data;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

PCfnxGroup CfnxUser::Group()
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_GETGROUP_USER;
	msg.dwParam1	= (DWORD) paccesstoken;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	return (PCfnxGroup) msg.dwParam1;
	}

VOID CfnxUser::Group( PCfnxGroup pGroup )
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_SETGROUP_USER;
	msg.dwParam1	= (DWORD) paccesstoken;
	msg.dwParam2	= (DWORD) pGroup->GetInternalPointer();
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

VOID CfnxUser::Quote( LONG lValue )
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_SETQUOTE_USER;
	msg.dwParam1	= (DWORD) paccesstoken;
	msg.dwParam2	= lValue;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

DWORD CfnxUser::Quote()
	{
	PCfnxMailBox box = new CfnxMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_GETQUOTE_USER;
	msg.dwParam1	= (DWORD) paccesstoken;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( Fenix->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	return msg.dwParam1;
	}

