/* **************************************************************************
*                                                                           *
*  Descr.CPP                                                                *
*                                                                           *
*  13-07-96                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classe CDescriptor que controla els descriptors de segment               *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "kernel\descr.h"
#include "errors.h"
#include "kernel\system.h"

// **************************************************************************
// Prepara l'objecte
// Com a entrada ha de rebre:
// pDesc	- Apuntador al descriptor inicial
CDescriptor::CDescriptor( PTDescriptor pDesc ) : CkeType( CID_Descriptor )
	{
	Descriptor( pDesc );
	}

// **************************************************************************
// Destructor de l'objecte
CDescriptor::~CDescriptor()
	{
	}

// **************************************************************************
// Indica si la classe de l'objecte s o no la que es passa com a parmetre
// Com a entrada ha de rebre:
// Cuid     	- Identificador de la classe
BOOL CDescriptor::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_Descriptor )
		return TRUE;
	else
		return CkeType::ClassCheck( Cuid );
	}

// **************************************************************************
// Retorna l'adrea del descriptor
PTDescriptor CDescriptor::PDescriptor()
	{
	if( binitialized )
		{
		SETERRORCODE( OK );
		return pdesc;
		}
	else
		{
		SETERRORCODE( DESC_UNINITIALIZED );
		return NULL;
		}
	}

// **************************************************************************
// Assigna un nou descriptor a l'objecte
// Com a entrada ha de rebre:
// pDesc	- Apuntador al descriptor nou
VOID CDescriptor::Descriptor( PTDescriptor pDesc )
	{
	pdesc	= pDesc;
	binitialized = (pdesc != NULL ? TRUE : FALSE);

	if( binitialized )
		pdesc->HighWord.Bits.Reserved_0 = 0;
	}

// **************************************************************************
// Inicialitza el descriptor amb un valor per defecte
VOID CDescriptor::Clear()
	{
	pdesc->LimitLow					= 0;
	pdesc->BaseLow						= 0;
	pdesc->HighWord.Bytes.BaseMid	= 0;
	pdesc->HighWord.Bytes.Flags1	= 0;
	pdesc->HighWord.Bytes.Flags2	= 0;
	pdesc->HighWord.Bytes.BaseHi	= 0;
	binitialized						= TRUE;
	}

// **************************************************************************
// Operacions que retornen algun valor del descriptor

// -- Base del descriptor
DWORD CDescriptor::Base()
	{
	if( binitialized )
		{
		SETERRORCODE( OK );
		return pdesc->BaseLow + ((DWORD) pdesc->HighWord.Bytes.BaseMid << 16) + ((DWORD) pdesc->HighWord.Bytes.BaseHi << 24);
		}
	else
		{
		SETERRORCODE( DESC_UNINITIALIZED );
		return 0L;
		}
	}

// -- Lmit
DWORD CDescriptor::Limit()
	{
	if( binitialized )
		{
		SETERRORCODE( OK );
		return pdesc->LimitLow + ((DWORD) pdesc->HighWord.Bits.LimitHi << 16);
		}
	else
		{
		SETERRORCODE( DESC_UNINITIALIZED );
		return 0L;
		}
	}

// -- Tipus
BYTE CDescriptor::Type()
	{
	if( binitialized )
		{
		SETERRORCODE( OK );
		return pdesc->HighWord.Bits.Type;
		}
	else
		{
		SETERRORCODE( DESC_UNINITIALIZED );
		return 0;
		}
	}

// -- DPL (descriptor protection level) de 0 a 3
BYTE CDescriptor::DPL()
	{
	if( binitialized )
		{
		SETERRORCODE( OK );
		return pdesc->HighWord.Bits.Dpl;
		}
	else
		{
		SETERRORCODE( DESC_UNINITIALIZED );
		return 0;
		}
	}

// -- Est present?
BOOL CDescriptor::Present()
	{
	if( binitialized )
		{
		SETERRORCODE( OK );
		return pdesc->HighWord.Bits.Pres;
		}
	else
		{
		SETERRORCODE( DESC_UNINITIALIZED );
		return FALSE;
		}
	}

// -- 'Bit' lliure per al sistema operatiu
BOOL CDescriptor::Sys()
	{
	if( binitialized )
		{
		SETERRORCODE( OK );
		return pdesc->HighWord.Bits.Sys;
		}
	else
		{
		SETERRORCODE( DESC_UNINITIALIZED );
		return FALSE;
		}
	}

// -- s gran?
BOOL CDescriptor::Big()
	{
	if( binitialized )
		{
		SETERRORCODE( OK );
		return pdesc->HighWord.Bits.Default_Big;
		}
	else
		{
		SETERRORCODE( DESC_UNINITIALIZED );
		return FALSE;
		}
	}

// -- La granularitat pot ser de 'byte' (0) o de pgina (1)
BOOL CDescriptor::Granularity()
	{
	if( binitialized )
		{
		SETERRORCODE( OK );
		return pdesc->HighWord.Bits.Granularity;
		}
	else
		{
		SETERRORCODE( DESC_UNINITIALIZED );
		return FALSE;
		}
	}

// **************************************************************************
// Operacions que assignen algun valor al descriptor

// -- Base
VOID CDescriptor::Base( DWORD base )
	{
	if( binitialized )
		{
		SETERRORCODE( OK );
		pdesc->BaseLow						= LOWORD( base );
		pdesc->HighWord.Bytes.BaseMid	= HIWORD( base );
		pdesc->HighWord.Bytes.BaseHi	= (BYTE) (HIWORD( base ) >> 8);
		}
	else
		SETERRORCODE( DESC_UNINITIALIZED );
	}

// -- Lmit
VOID CDescriptor::Limit( DWORD limit )
	{
	if( binitialized )
		{
		SETERRORCODE( OK );
		pdesc->LimitLow						= LOWORD( limit );
		pdesc->HighWord.Bits.LimitHi		= HIWORD( limit );
		}
	else
		SETERRORCODE( DESC_UNINITIALIZED );
	}

// -- Tipus
VOID CDescriptor::Type( BYTE type )
	{
	if( binitialized )
		{
		SETERRORCODE( OK );
		pdesc->HighWord.Bits.Type = type;
		}
	else
		SETERRORCODE( DESC_UNINITIALIZED );
	}

// -- DPL
VOID CDescriptor::DPL( BYTE dpl )
	{
	if( binitialized )
		{
		SETERRORCODE( OK );
		pdesc->HighWord.Bits.Dpl = dpl;
		}
	else
		SETERRORCODE( DESC_UNINITIALIZED );
	}

// -- Present?
VOID CDescriptor::Present( BOOL P )
	{
	if( binitialized )
		{
		SETERRORCODE( OK );
		pdesc->HighWord.Bits.Pres = P;
		}
	else
		SETERRORCODE( DESC_UNINITIALIZED );
	}

// -- 'Bit' lliure per al sistema operatiu
VOID CDescriptor::Sys( BOOL S )
	{
	if( binitialized )
		{
		SETERRORCODE( OK );
		pdesc->HighWord.Bits.Sys = S;
		}
	else
		SETERRORCODE( DESC_UNINITIALIZED );
	}

// -- Gran?
VOID CDescriptor::Big( BOOL B )
	{
	if( binitialized )
		{
		SETERRORCODE( OK );
		pdesc->HighWord.Bits.Default_Big = B;
		}
	else
		SETERRORCODE( DESC_UNINITIALIZED );
	}

// -- Granularitat de pgina?
VOID CDescriptor::Granularity( BOOL G )
	{
	if( binitialized )
		{
		SETERRORCODE( OK );
		pdesc->HighWord.Bits.Granularity = G;
		}
	else
		SETERRORCODE( DESC_UNINITIALIZED );
	}

// **************************************************************************
// Operacions que comproven algun valor del tipus de descriptor

// -- El descriptor s del 'hardware'
BOOL CDescriptor::Processor()
	{
	if( binitialized )
		{
		SETERRORCODE( OK );

		if( Type() & 0x10 )
			return FALSE;
		else
			return TRUE;
		}
	else
		SETERRORCODE( DESC_UNINITIALIZED );

	return FALSE;
	}

// -- El descriptor s del tipus: dades
BOOL CDescriptor::Data()
	{
	if( binitialized )
		{
		SETERRORCODE( OK );

		if( Type() & 0x10 && !(Type() & 0x08) )
			return TRUE;
		else
			return FALSE;
		}
	else
		SETERRORCODE( DESC_UNINITIALIZED );

	return FALSE;
	}

// -- El descriptor s del tipus: codi
BOOL CDescriptor::Code()
	{
	if( binitialized )
		{
		SETERRORCODE( OK );

		if( Type() & 0x10 && Type() & 0x08 )
			return TRUE;
		else
			return FALSE;
		}
	else
		SETERRORCODE( DESC_UNINITIALIZED );

	return FALSE;
	}

// -- El descriptor t la caracterstica de crixer cap avall
BOOL CDescriptor::Down()
	{
	if( binitialized )
		{
		SETERRORCODE( OK );

		if( Data() && Type() & 0x04 )
			return TRUE;
		else
			return FALSE;
		}
	else
		SETERRORCODE( DESC_UNINITIALIZED );

	return FALSE;
	}

// -- El descriptor pot ser escrit (noms de dades)
BOOL CDescriptor::Writeable()
	{
	if( binitialized )
		{
		SETERRORCODE( OK );

		if( Data() && Type() & 0x02 )
			return TRUE;
		else
			return FALSE;
		}
	else
		SETERRORCODE( DESC_UNINITIALIZED );

	return FALSE;
	}

// -- El descriptor ha estat accedit
BOOL CDescriptor::Accessed()
	{
	if( binitialized )
		{
		SETERRORCODE( OK );

		if( Type() & 0x01 && !Processor() )
			return TRUE;
		else
			return FALSE;
		}
	else
		SETERRORCODE( DESC_UNINITIALIZED );

	return FALSE;
	}

// -- El descriptor s conformat
BOOL CDescriptor::Conformed()
	{
	if( binitialized )
		{
		SETERRORCODE( OK );

		if( Code() && Type() & 0x04 )
			return TRUE;
		else
			return FALSE;
		}
	else
		SETERRORCODE( DESC_UNINITIALIZED );

	return FALSE;
	}

// -- El descriptor es pot llegir (noms codi)
BOOL CDescriptor::Readable()
	{
	if( binitialized )
		{
		SETERRORCODE( OK );

		if( Code() && Type() & 0x02 )
			return TRUE;
		else
			return FALSE;
		}
	else
		SETERRORCODE( DESC_UNINITIALIZED );

	return FALSE;
	}

// -- El descriptor s de tipus: TSS386 lliure
BOOL CDescriptor::FreeTSS386()
	{
	if( binitialized )
		{
		SETERRORCODE( OK );

		if( Type() == 9 )
			return TRUE;
		else
			return FALSE;
		}
	else
		SETERRORCODE( DESC_UNINITIALIZED );

	return FALSE;
	}

// -- El descriptor s de tipus: TSS386 ocupat
BOOL CDescriptor::BusyTSS386()
	{
	if( binitialized )
		{
		SETERRORCODE( OK );

		if( Type() == 0xb )
			return TRUE;
		else
			return FALSE;
		}
	else
		SETERRORCODE( DESC_UNINITIALIZED );

	return FALSE;
	}

// -- El descriptor s de tipus: LDT
BOOL CDescriptor::LDT()
	{
	if( binitialized )
		{
		SETERRORCODE( OK );

		if( Type() == 2 )
			return TRUE;
		else
			return FALSE;
		}
	else
		SETERRORCODE( DESC_UNINITIALIZED );

	return FALSE;
	}

// -- El descriptor s de tipus: CallGate
BOOL CDescriptor::Callgate()
	{
	if( binitialized )
		{
		SETERRORCODE( OK );

		if( Type() == 0xc )
			return TRUE;
		else
			return FALSE;
		}
	else
		SETERRORCODE( DESC_UNINITIALIZED );

	return FALSE;
	}

// -- El descriptor s de tipus: TaskGate
BOOL CDescriptor::Taskgate()
	{
	if( binitialized )
		{
		SETERRORCODE( OK );

		if( Type() == 5 )
			return TRUE;
		else
			return FALSE;
		}
	else
		SETERRORCODE( DESC_UNINITIALIZED );

	return FALSE;
	}

// -- El descriptor s de tipus: IntGate386
BOOL CDescriptor::Intgate386()
	{
	if( binitialized )
		{
		SETERRORCODE( OK );

		if( Type() == 0xe )
			return TRUE;
		else
			return FALSE;
		}
	else
		SETERRORCODE( DESC_UNINITIALIZED );

	return FALSE;
	}

// -- El descriptor s de tipus: TrapGate386
BOOL CDescriptor::Trapgate386()
	{
	if( binitialized )
		{
		SETERRORCODE( OK );

		if( Type() == 0xf )
			return TRUE;
		else
			return FALSE;
		}
	else
		SETERRORCODE( DESC_UNINITIALIZED );

	return FALSE;
	}

// **************************************************************************
// Operacions que modifiquen algun valor del tipus de descriptor

// -- El descriptor ha de ser del 'hardware'
VOID CDescriptor::SetProcessor()
	{
	if( binitialized )
		{
		SETERRORCODE( OK );
		pdesc->HighWord.Bits.Type &= 0xf;
		}
	else
		SETERRORCODE( DESC_UNINITIALIZED );
	}

// -- El descriptor ha de ser de dades
VOID CDescriptor::SetData()
	{
	if( binitialized )
		{
		SETERRORCODE( OK );
		pdesc->HighWord.Bits.Type &= 0x0f;
		pdesc->HighWord.Bits.Type |= 0x10;
		}
	else
		SETERRORCODE( DESC_UNINITIALIZED );
	}

// -- El descriptor ha de ser de codi
VOID CDescriptor::SetCode()
	{
	if( binitialized )
		{
		SETERRORCODE( OK );
		pdesc->HighWord.Bits.Type |= 0x18;
		}
	else
		SETERRORCODE( DESC_UNINITIALIZED );
	}

// -- El descriptor ha de crixer cap avall (1) o no (0)
VOID CDescriptor::SetDown( BOOL bit )
	{
	if( binitialized )
		{
		SETERRORCODE( OK );

		if( Data() )
			{
			if( bit )
				pdesc->HighWord.Bits.Type |= 0x04;
			else
				pdesc->HighWord.Bits.Type &= 0xfb;
			}
		else
			SETERRORCODE( DESC_BAD_TYPE );
		}
	else
		SETERRORCODE( DESC_UNINITIALIZED );
	}

// -- El descriptor ha de poder ser escrit (1) o no (0)
VOID CDescriptor::SetWriteable( BOOL bit )
	{
	if( binitialized )
		{
		SETERRORCODE( OK );

		if( Data() )
			{
			if( bit )
				pdesc->HighWord.Bits.Type |= 0x02;
			else
				pdesc->HighWord.Bits.Type &= 0xfd;
			}
		else
			SETERRORCODE( DESC_BAD_TYPE );
		}
	else
		SETERRORCODE( DESC_UNINITIALIZED );
	}

// -- El descriptor ha estat accedit (1) o no (0)
VOID CDescriptor::SetAccessed( BOOL bit )
	{
	if( binitialized )
		{
		SETERRORCODE( OK );

		if( Data() )
			{
			if( bit )
				pdesc->HighWord.Bits.Type |= 0x01;
			else
				pdesc->HighWord.Bits.Type &= 0xfe;
			}
		else
			SETERRORCODE( DESC_BAD_TYPE );
		}
	else
		SETERRORCODE( DESC_UNINITIALIZED );
	}

// -- El descriptor ha de ser conformat (1) o no (0)
VOID CDescriptor::SetConformed( BOOL bit )
	{
	if( binitialized )
		{
		SETERRORCODE( OK );

		if( Code() )
			{
			if( bit )
				pdesc->HighWord.Bits.Type |= 0x04;
			else
				pdesc->HighWord.Bits.Type &= 0xfb;
			}
		else
			SETERRORCODE( DESC_BAD_TYPE );
		}
	else
		SETERRORCODE( DESC_UNINITIALIZED );
	}

// -- El descriptor ha de poder ser llegit (1) o no (0)
VOID CDescriptor::SetReadable( BOOL bit )
	{
	if( binitialized )
		{
		SETERRORCODE( OK );

		if( Code() )
			{
			if( bit )
				pdesc->HighWord.Bits.Type |= 0x02;
			else
				pdesc->HighWord.Bits.Type &= 0xfd;
			}
		else
			SETERRORCODE( DESC_BAD_TYPE );
		}
	else
		SETERRORCODE( DESC_UNINITIALIZED );
	}

// -- El descriptor ha de ser: TSS386 lliure
VOID CDescriptor::SetFreeTSS386()
	{
	if( binitialized )
		{
		SETERRORCODE( OK );

		if( Processor() )
			pdesc->HighWord.Bits.Type = 9;
		else
			SETERRORCODE( DESC_BAD_TYPE );
		}
	else
		SETERRORCODE( DESC_UNINITIALIZED );
	}

// -- El descriptor ha de ser: TSS386 ocupat
VOID CDescriptor::SetBusyTSS386()
	{
	if( binitialized )
		{
		SETERRORCODE( OK );

		if( Processor() )
			pdesc->HighWord.Bits.Type = 0xb;
		else
			SETERRORCODE( DESC_BAD_TYPE );
		}
	else
		SETERRORCODE( DESC_UNINITIALIZED );
	}

// -- El descriptor ha de ser: LDT
VOID CDescriptor::SetLDT()
	{
	if( binitialized )
		{
		SETERRORCODE( OK );

		if( Processor() )
			pdesc->HighWord.Bits.Type = 2;
		else
			SETERRORCODE( DESC_BAD_TYPE );
		}
	else
		SETERRORCODE( DESC_UNINITIALIZED );
	}

// -- El descriptor ha de ser: CallGate
VOID CDescriptor::SetCallgate()
	{
	if( binitialized )
		{
		SETERRORCODE( OK );

		if( Processor() )
			pdesc->HighWord.Bits.Type = 0xc;
		else
			SETERRORCODE( DESC_BAD_TYPE );
		}
	else
		SETERRORCODE( DESC_UNINITIALIZED );
	}

// -- El descriptor ha de ser: TaskGate
VOID CDescriptor::SetTaskgate()
	{
	if( binitialized )
		{
		SETERRORCODE( OK );

		if( Processor() )
			pdesc->HighWord.Bits.Type = 5;
		else
			SETERRORCODE( DESC_BAD_TYPE );
		}
	else
		SETERRORCODE( DESC_UNINITIALIZED );
	}

// -- El descriptor ha de ser: IntGate386
VOID CDescriptor::SetIntgate386()
	{
	if( binitialized )
		{
		SETERRORCODE( OK );

		if( Processor() )
			pdesc->HighWord.Bits.Type = 0xe;
		else
			SETERRORCODE( DESC_BAD_TYPE );
		}
	else
		SETERRORCODE( DESC_UNINITIALIZED );
	}

// -- El descriptor ha de ser: TrapGate386
VOID CDescriptor::SetTrapgate386()
	{
	if( binitialized )
		{
		SETERRORCODE( OK );

		if( Processor() )
			pdesc->HighWord.Bits.Type = 0xf;
		else
			SETERRORCODE( DESC_BAD_TYPE );
		}
	else
		SETERRORCODE( DESC_UNINITIALIZED );
	}

