/* **************************************************************************
*                                                                           *
*  EFlags.CPP                                                               *
*                                                                           *
*  13-07-96                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classe CEFLAGS per a la utilitzaci dels Flags                           *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "kernel\eflags.h"
#include "errors.h"
#include "kernel\asm.h"
#include "kernel\system.h"

// **************************************************************************
// Constructor de la classe
// Com a entrada ha de rebre:
// f        	- Dona un valor inicial als Flags
CEFLAGS::CEFLAGS( DWORD f ) : CkeType( CID_EFLAGS )
	{
	Flags( f );
	}

// **************************************************************************
// Destructor de la classe
CEFLAGS::~CEFLAGS()
	{
	}

// **************************************************************************
// Indica si la classe de l'objecte s o no la que es passa com a parmetre
// Com a entrada ha de rebre:
// Cuid     	- Identificador de la classe
BOOL CEFLAGS::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_EFLAGS )
		return TRUE;
	else
		return CkeType::ClassCheck( Cuid );
	}

// **************************************************************************
// Dona un valor als Flags
// Com a entrada ha de rebre:
// f        	- Valor desitjat
VOID CEFLAGS::Flags( DWORD f )
	{
	flags.DWord.Flags	= f;
	}

// **************************************************************************
// Retorna el valor actual dels 'Flags'
DWORD CEFLAGS::Flags()
	{
	return flags.DWord.Flags;
	}

// **************************************************************************
// Obt el valor dels 'flags' del 'hardware'
VOID CEFLAGS::GetHard()
	{
	flags.DWord.Flags = GetEFLAGS();
	}

// **************************************************************************
// Selecciona el valor dels 'flags' del 'hardware'
VOID CEFLAGS::SetHard()
	{
	SetEFLAGS( flags.DWord.Flags );
	}

// **************************************************************************
// Aquests metodes retornen l'estat d'un 'flag' concret

// -- Carry
BOOL CEFLAGS::CF()
	{
	return flags.DWord.Bits.CF;
	}

// -- Parity
BOOL CEFLAGS::PF()
	{
	return flags.DWord.Bits.PF;
	}

// -- Aux
BOOL CEFLAGS::AF()
	{
	return flags.DWord.Bits.AF;
	}

// -- Zero
BOOL CEFLAGS::ZF()
	{
	return flags.DWord.Bits.ZF;
	}

// -- Sign
BOOL CEFLAGS::SF()
	{
	return flags.DWord.Bits.SF;
	}

// -- Trap
BOOL CEFLAGS::TF()
	{
	return flags.DWord.Bits.TF;
	}

// -- Interrupt
BOOL CEFLAGS::IF()
	{
	return flags.DWord.Bits.IF;
	}

// -- Direction
BOOL CEFLAGS::DF()
	{
	return flags.DWord.Bits.DF;
	}

// -- Overflow
BOOL CEFLAGS::OF()
	{
	return flags.DWord.Bits.OF;
	}

// -- IOPrivilegeLevel
BYTE CEFLAGS::IOPL()
	{
	return flags.DWord.Bits.IOPL;
	}

// -- NestedTask
BOOL CEFLAGS::NT()
	{
	return flags.DWord.Bits.NT;
	}

// -- Resume
BOOL CEFLAGS::RF()
	{
	return flags.DWord.Bits.RF;
	}

// -- VirtualMode
BOOL CEFLAGS::VM()
	{
	return flags.DWord.Bits.VM;
	}

// **************************************************************************
// Aquestes funcions modifiquen algun dels 'flags'

// -- Carry
VOID CEFLAGS::CF( BOOL f )
	{
	flags.DWord.Bits.CF	= f;
	}

// -- Parity
VOID CEFLAGS::PF( BOOL f )
	{
	flags.DWord.Bits.PF	= f;
	}

// -- Aux
VOID CEFLAGS::AF( BOOL f )
	{
	flags.DWord.Bits.AF	= f;
	}

// -- Zero
VOID CEFLAGS::ZF( BOOL f )
	{
	flags.DWord.Bits.ZF	= f;
	}

// -- Sign
VOID CEFLAGS::SF( BOOL f )
	{
	flags.DWord.Bits.SF	= f;
	}

// -- Trap
VOID CEFLAGS::TF( BOOL f )
	{
	flags.DWord.Bits.TF	= f;
	}

// -- Interrupt
VOID CEFLAGS::IF( BOOL f )
	{
	flags.DWord.Bits.IF	= f;
	}

// -- Direction
VOID CEFLAGS::DF( BOOL f )
	{
	flags.DWord.Bits.DF	= f;
	}

// -- Overflow
VOID CEFLAGS::OF( BOOL f )
	{
	flags.DWord.Bits.OF	= f;
	}

// -- IOPrivilegeLevel
VOID CEFLAGS::IOPL( BYTE f )
	{
	flags.DWord.Bits.IOPL	= f;
	}

// -- NestedTask
VOID CEFLAGS::NT( BOOL f )
	{
	flags.DWord.Bits.NT	= f;
	}

// -- Resume
VOID CEFLAGS::RF( BOOL f )
	{
	flags.DWord.Bits.RF	= f;
	}

// -- VirtualMode
VOID CEFLAGS::VM( BOOL f )
	{
	flags.DWord.Bits.VM	= f;
	}

