/* **************************************************************************
*                                                                           *
*  GDT.CPP                                                                  *
*                                                                           *
*  24-01-97                                                    BUILD:0002   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classe per al control de la GDT                                          *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "kernel\gdt.h"
#include "errors.h"
#include "kernel\asm.h"
#include "kernel\kernel.h"
#include "kernel\system.h"

extern PCkeKernel _export Kernel;
extern WORD size;
extern DWORD addr;

// **************************************************************************
// Prepara l'objecte
// Com a entrada ha de rebre:
// g        	- Apuntador a l'inici de la taula
// Size     	- Tamany de la taula
CGDT::CGDT( PTDescriptor g, WORD size ) : CSystemTable( g, size )
	{
	id	= CID_GDT;
	}

// **************************************************************************
// Destrueix l'objecte (no s'arriba a destruir mai)
CGDT::~CGDT()
	{
	}

// **************************************************************************
// Indica si la classe de l'objecte s o no la que es passa com a parmetre
// Com a entrada ha de rebre:
// Cuid     	- Identificador de la classe
BOOL CGDT::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_GDT )
		return TRUE;
	else
		return CSystemTable::ClassCheck( Cuid );
	}

// **************************************************************************
// Inicialitza la taula amb uns valors determinats
VOID CGDT::Clear()
	{
	for( WORD count = 0; count < wsize; count++ )
		{
		CDescriptor cDesc( &pdesc[ count ] );
		cDesc.Clear();
		}

// Reservem el primer (el processador no en permet el seu s)
	CDescriptor cDesc( &pdesc[ 0 ] );
	cDesc.Present();
	}

// **************************************************************************
// Li indica al processador que utilitzi aquesta taula
VOID CGDT::SetHard()
	{
	SETERRORCODE( UNSUPPORTED_FUNC );
	}

// **************************************************************************
// Obt del processador la taula que est utilitzant actualment
VOID CGDT::GetHard()
	{
	DWORD flags = CLI();

	SGDT();
	pdesc = (PTDescriptor) addr; // Adrea lineal on es troba el primer descriptor
	wsize = size;

	STI( flags );
	}

