/* **************************************************************************
*                                                                           *
*  Heap.CPP                                                                 *
*                                                                           *
*  06-03-97                                                    BUILD:0002   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Control dels 'heaps'                                                     *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "kernel\heap.h"
#include "errors.h"
#include "kernel\asm.h"
#include "string.h"
#include "kernel\system.h"

// **************************************************************************
// Constructor de la classe
CkeHeap::CkeHeap( PTHeapItem pFirst, DWORD dwSize ) : CkeType( CID_Heap )
	{
	DWORD flags = CLI();

	pfirst = pFirst;
	dwsize = dwSize;

	STI( flags );
	}

// **************************************************************************
// Destructor de la classe
CkeHeap::~CkeHeap()
	{
// Hauria d'esborrar tots els elements del 'Heap'? -BUG
	}

// **************************************************************************
// Retorna el tamany del 'heap' en 'bytes'
DWORD CkeHeap::GetSize()
	{
	return dwsize;
	}

// **************************************************************************
// Redefineix el tamany del 'heap'
// Com a entrada ha de rebre:
// Size  	  	- Nou tamany del 'heap'
VOID CkeHeap::SetSize( DWORD dwSize )
	{
	DWORD flags = CLI();
	dwsize = dwSize;
	STI( flags );
	}

// **************************************************************************
// Retorna el primer element del 'heap'
PTHeapItem CkeHeap::GetFirstItem()
	{
	return pfirst;
	}

// **************************************************************************
// Selecciona un nou element com a primer del 'heap'
// Com a entrada ha de rebre:
// First 	  	- Nou primer element del 'heap'
VOID CkeHeap::SetFirstItem( PTHeapItem pFirst )
	{
	DWORD flags = CLI();
	pfirst = pFirst;
	STI( flags );
	}

// **************************************************************************
// Obt la quantitat total de 'bytes' lliures del 'heap'
DWORD CkeHeap::GetTotalFree()
	{
	DWORD flags = CLI();

	DWORD dwtotal = 0;
	PTHeapItem Item = pfirst;

	while( Item != NULL )
		{
		if( Item->Type == HEAP_FREE )
			dwtotal += Item->dwSize;

		Item = Item->pNext;
		}

	STI( flags );

	return dwtotal;
	}

// **************************************************************************
// Obt la quantitat de 'bytes' de l'element lliure ms gran del 'heap'
DWORD CkeHeap::GetMaxFree()
	{
	DWORD flags = CLI();

	DWORD dwmax = 0;
	PTHeapItem Item = pfirst;

	while( Item != NULL )
		{
		if( Item->Type == HEAP_FREE && Item->dwSize > dwmax )
			dwmax = Item->dwSize;

		Item = Item->pNext;
		}

	STI( flags );

	return dwmax;
	}

// **************************************************************************
// Retorna la quantita d'elements que hi ha en el 'heap'
DWORD CkeHeap::GetItemCount()
	{
	DWORD flags = CLI();

	DWORD dwcount = 0;
	PTHeapItem Item = pfirst;

	while( Item != NULL )
		{
		dwcount++;
		Item = Item->pNext;
		}

	STI( flags );

	return dwcount;
	}

