/* **************************************************************************
*                                                                           *
*  IDT.CPP                                                                  *
*                                                                           *
*  24-01-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classe per al control de la IDT                                          *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "kernel\idt.h"
#include "errors.h"
#include "kernel\asm.h"
#include "kernel\interrup.h"
#include "kernel\intgate.h"
#include "kernel\selector.h"
#include "string.h"
#include "kernel\kernel.h"
#include "kernel\system.h"

extern PCkeKernel _export Kernel;
extern WORD size;
extern DWORD addr;

// **************************************************************************
// Prepara l'objecte
// Com a entrada ha de rebre:
// i        	- Apuntador a l'inici de la taula
// size     	- Tamany de la taula
CIDT::CIDT( PTDescriptor i, WORD size ) : CSystemTable( i, size )
	{
	id	= CID_IDT;
	}

// **************************************************************************
// Destrueix l'objecte
CIDT::~CIDT()
	{
	}

// **************************************************************************
// Indica si la classe de l'objecte s o no la que es passa com a parmetre
// Com a entrada ha de rebre:
// Cuid     	- Identificador de la classe
BOOL CIDT::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_IDT )
		return TRUE;
	else
		return CSystemTable::ClassCheck( Cuid );
	}

// **************************************************************************
// Inicialitza a la taula amb uns valors per defecte
VOID CIDT::Clear()
	{
	WORD OSCode;

	{ // Preparem un selector cap al codi del sistema operatiu
	CSelector selector;
	selector.Index( 1 );
	selector.RPL( 0 );
	selector.Table( SELECTOR_GDT );
	OSCode = selector.Selector();
	}

	for( WORD count = 0; count < wsize; count++ )
		{
		CIntGate cDesc( &pdesc[ count ] );
		cDesc.Clear();
		cDesc.Selector( OSCode );
		cDesc.Offset( (DWORD) UnhandledInterrupt ); // Inicialitzem totes les interrupcions
		}
	}

// **************************************************************************
// Fa que el processador utilitzi aquesta taula
VOID CIDT::SetHard()
	{
	SETERRORCODE( UNSUPPORTED_FUNC );
	}

// **************************************************************************
// Obt la taula que est utilitzant el processador actualment
VOID CIDT::GetHard()
	{
	DWORD flags = CLI();

	SIDT();
	pdesc = (PTDescriptor) addr; // Adrea lineal del primer descriptor
	wsize = size;

	STI( flags );
	}

