/* **************************************************************************
*                                                                           *
*  IntGate.CPP                                                              *
*                                                                           *
*  13-07-96                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classe per al control de les portes d'interrupci                        *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "kernel\intgate.h"
#include "errors.h"
#include "kernel\system.h"

// **************************************************************************
// Prepara l'objecte
// Com a entrada ha de rebre:
// pDescr	- Apunta al descriptor de la CallGate
CIntGate::CIntGate( PTDescriptor pDescr ) : CGate( pDescr )
	{
	id	= CID_IntGate;
	}

// **************************************************************************
// Destrueix l'objecte
CIntGate::~CIntGate()
	{
	}

// **************************************************************************
// Indica si la classe de l'objecte s o no la que es passa com a parmetre
// Com a entrada ha de rebre:
// Cuid     	- Identificador de la classe
BOOL CIntGate::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_IntGate )
		return TRUE;
	else
		return CGate::ClassCheck( Cuid );
	}

// **************************************************************************
// Retorna el nombre de dobles paraules que pren com a parmetres
BYTE CIntGate::Params()
	{
	if( binitialized )
		SETERRORCODE( GATE_NOTPERMITTED );
	else
		SETERRORCODE( GATE_UNINITIALIZED );

	return 0;
	}

// **************************************************************************
// Prepara l'objecte per a utilitzar p dobles paraules com a parmetres
// Com a entrada ha de rebre:
// p	- Nombre de dobles paraules que formen els parmetres
VOID CIntGate::Params( BYTE )
	{
	if( binitialized )
		SETERRORCODE( GATE_NOTPERMITTED );
	else
		SETERRORCODE( GATE_UNINITIALIZED );
	}

// **************************************************************************
// Prepara el descriptor
// Com a entrada ha de rebre:
// Desc	- Apuntador cap al descriptor
VOID CIntGate::Descriptor( PTDescriptor pDesc )
	{
	CGate::Descriptor( pDesc );

	SetProcessor();  // Descriptor del processador
	SetIntgate386(); // Porta d'interrupci del 386
	DPL( 0 );		  // Per defecte, del sistema operatiu
	Present( TRUE ); // Ocupat i present
	}

