/* **************************************************************************
*                                                                           *
*  LDT.CPP                                                                  *
*                                                                           *
*  24-01-97                                                    BUILD:0002   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classe per al control de les LDTs                                        *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "kernel\ldt.h"
#include "errors.h"
#include "kernel\asm.h"
#include "kernel\kernel.h"
#include "kernel\system.h"

extern PCkeKernel _export Kernel;
extern WORD size;
extern DWORD addr;

// **************************************************************************
// Contructor de la classe
// Com a entrada ha de rebre:
// gdt      	- Apuntador al descriptor de tipus LDT dins la GDT
CLDT::CLDT( WORD wEntry ) : CSystemTable()
	{
	id = CID_LDT;

	GDT( wEntry );
	}

// **************************************************************************
// Destrueix l'objecte
CLDT::~CLDT()
	{
	}

// **************************************************************************
// Indica si la classe de l'objecte s o no la que es passa com a parmetre
// Com a entrada ha de rebre:
// Cuid     	- Identificador de la classe
BOOL CLDT::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_LDT )
		return TRUE;
	else
		return CSystemTable::ClassCheck( Cuid );
	}

// **************************************************************************
// Inicialitza la taula amb uns valors per defecte
VOID CLDT::Clear()
	{
	for( WORD count = 0; count < wsize; count++ )
		{
		CDescriptor entry( &pdesc[ count ] );
		entry.Clear();
		}
	}

// **************************************************************************
// Fa que el 'hardware' utilitzi aquesta taula
VOID CLDT::SetHard()
	{
	if( wgdtentry )
		{
		LLDT( &wgdtentry );
		SETERRORCODE( OK );
		}
	else
		SETERRORCODE( LDT_UNINITIALIZED );
	}

// **************************************************************************
// Obt la taula que esta utilitzant actualment el 'hardware'
VOID CLDT::GetHard()
	{
	SLDT( &wgdtentry );

	DWORD flags = CLI();

	SGDT(); // Obtenim la GDT
	CDescriptor entry( (PTDescriptor) addr + wgdtentry * sizeof( TDescriptor ) );
	// Coneixem el descriptor de la GDT que cont l'adrea i el tamany de la LDT
	pdesc = (PTDescriptor) entry.Base();
	wsize = (WORD) (entry.Limit() / sizeof( TDescriptor ));

	STI( flags );
	}

// **************************************************************************
// Retorna l'adrea del descriptor de tipus LDT dins la GDT
WORD CLDT::GDT()
	{
	if( wgdtentry )
		{
		SETERRORCODE( OK );
		return wgdtentry;
		}
	else
		SETERRORCODE( LDT_UNINITIALIZED );

	return NULL;
	}

// **************************************************************************
// Selecciona un nou descriptor de tipus LDT dins la GDT
// Com a entrada ha de rebre:
// gdt      	- Apuntador al descriptor de tipus LDT
VOID CLDT::GDT( WORD wEntry )
	{
	if( wEntry )
		{
		PCGDT gdt = System->GDT();
		CDescriptor *descr = new CDescriptor( gdt->Descriptor( wEntry ) );
		// Modifiquem l'adrea i el tamany en el descriptor que apunta a la LDT
		pdesc = (PTDescriptor) descr->Base();
		wsize = (WORD) ((descr->Limit() + 1) / sizeof( TDescriptor ) );

		delete descr;
		}
	else
		pdesc = NULL;

	wgdtentry = wEntry;
	}

