/* **************************************************************************
*                                                                           *
*  List.CPP                                                                 *
*                                                                           *
*  19-03-97                                                    BUILD:0002   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classes genriques per a llistes i llistes doblement encadenades         *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "kernel\list.h"
#include "errors.h"
#include "string.h"
#include "kernel\kernel.h"
#include "kernel\asm.h"
#include "kernel\system.h"

extern PCkeKernel _export Kernel;

// **************************************************************************
// Constructor de la classe
// Com a entrada ha de rebre:
// next     	- Apunta a l'element segent de la llista
CkeListItem::CkeListItem( PCkeListItem next ) : CkeType( CID_ListItem )
	{
	SetNext( next );
	}

// **************************************************************************
// Destrueix l'objecte
CkeListItem::~CkeListItem()
	{
	}

// **************************************************************************
// Indica si la classe de l'objecte s o no la que es passa com a parmetre
// Com a entrada ha de rebre:
// Cuid     	- Identificador de la classe
BOOL CkeListItem::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_ListItem )
		return TRUE;
	else
		return CkeType::ClassCheck( Cuid );
	}

// **************************************************************************
// Retorna l'objecte segent de la llista
PCkeListItem CkeListItem::GetNext()
	{
	return pnext;
	}

// **************************************************************************
// Selecciona l'objecte segent de la llista
// Com a entrada ha de rebre:
// next     	- Apuntador al nou objecte seguent
VOID CkeListItem::SetNext( PCkeListItem next )
	{
	pnext	= next;
	}

// **************************************************************************
// Constructor de la classe
// Com a entrada ha de rebre:
// prev     	- Objecte anterior
// next     	- Objecte segent
CkeDblListItem::CkeDblListItem( PCkeDblListItem prev, PCkeDblListItem next ) : CkeListItem( (PCkeListItem) next )
	{
	id	= CID_DblListItem;
	SetPrev( prev );
	}

// **************************************************************************
// Destrueix l'objecte
CkeDblListItem::~CkeDblListItem()
	{
/*
	if( pprev )
		pprev->SetNext( pnext );

	if( pnext )
		((PCkeDblListItem) pnext)->SetPrev( pprev );
*/
	pprev = NULL;
	pnext = NULL;
	}

// **************************************************************************
// Indica si la classe de l'objecte s o no la que es passa com a parmetre
// Com a entrada ha de rebre:
// Cuid     	- Identificador de la classe
BOOL CkeDblListItem::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_DblListItem )
		return TRUE;
	else
		return CkeListItem::ClassCheck( Cuid );
	}

// **************************************************************************
// Retorna l'objecte anterior de la llista
PCkeDblListItem CkeDblListItem::GetPrev()
	{
	return pprev;
	}

// **************************************************************************
// Selecciona un nou objecte anterior
// Com a entrada ha de rebre:
// prev     	- Objecte que sera el nou anterior
VOID CkeDblListItem::SetPrev( PCkeDblListItem prev )
	{
	pprev	= prev;
	}

// **************************************************************************
// Constructor de la classe
CkeLIFOList::CkeLIFOList() : CkeType( CID_LIFOList )
	{
	pfirst = NULL;
	dwelements = 0L; // La llista comena buida
	}

// **************************************************************************
// Destructor de la classe
CkeLIFOList::~CkeLIFOList()
	{
	DWORD flags = CLI();
	// Hem d'esborrar tots els elements
	PCkeListItem pitem = pfirst;

	while( pitem )
		{
		PCkeListItem pnext = pitem->GetNext();
		delete pitem;
		pitem = pnext;
		dwelements--;
		}

	STI( flags );
	}

// **************************************************************************
// Obt el primer element de la llista
PCkeListItem CkeLIFOList::Get()
	{
	return pfirst;
	}

// **************************************************************************
// Afegeix un element a la llista
// Com a entrada ha de rebre:
// Item	   	- Element a afegir
VOID CkeLIFOList::Add( PCkeListItem pItem )
	{
	DWORD flags = CLI();

	dwelements++; // Un element ms
	pItem->SetNext( pfirst ); // Al principi de la llista

	if( pfirst )
		{
		if( pfirst->ClassCheck( CID_DblListItem ) ) // Les llistes doblement encadenades tenen dos apuntadors
			((PCkeDblListItem) pfirst)->SetPrev( (PCkeDblListItem) pItem );
		}

	pfirst = pItem; // El primer

	STI( flags );
	}

// **************************************************************************
// Treu un element de la llista sense esborrar-lo realment
// Com a entrada ha de rebre:
// Item	   	- Element a eliminar
VOID CkeLIFOList::Delete( PCkeListItem pItem )
	{
	DWORD flags = CLI();

	if( pfirst ) // Si hi ha algun element
		{
		if( pfirst == pItem ) // Hem d'eliminar el primer?
			{
			pfirst = pItem->GetNext(); // El nou primer

			if( pfirst && pfirst->ClassCheck( CID_DblListItem ) )
				((PCkeDblListItem) pfirst)->SetPrev( NULL ); // Enlla doble
			}
		else // No hem d'eliminar el primer
			{
			if( pItem->ClassCheck( CID_DblListItem ) )
				{ // En les llistes doblement encadenades podem trobar l'anterior fcilment
				PCkeListItem pelem = ((PCkeDblListItem) pItem)->GetPrev();

				pelem->SetNext( pItem->GetNext() ); // Enllacem l'anterior amb el segent
				if( pItem->GetNext() ) // I el segent amb l'anterior
					((PCkeDblListItem) pItem->GetNext())->SetPrev( (PCkeDblListItem) pelem );
				}
			else // En llistes simplement encadenades s ms costs
				{
				PCkeListItem pelem = pfirst;
				// Cerquem l'element anterior al que volem eliminar
				while( pelem->GetNext() != pItem && pelem->GetNext() )
					pelem = pelem->GetNext();

				if( pelem->GetNext() == pItem ) // Ens el saltem
					pelem->SetNext( pItem->GetNext() );
				else // No s'ha trobat a la llista
					{
					STI( flags );
					return;
					}
				}
			}

		dwelements--;
		}
	else // Intentem eliminar elements d'una llista buida
		{
		STI( flags );
		return;
		}

	pItem->SetNext( NULL ); // Allem l'element
	if( pItem->ClassCheck( CID_DblListItem ) )
		((PCkeDblListItem) pItem)->SetPrev( NULL );

	STI( flags );
	}

// **************************************************************************
// Constructor de la classe
CkeFIFOList::CkeFIFOList() : CkeLIFOList()
	{
	id	= CID_FIFOList;
	plast = NULL;
	}

// **************************************************************************
// Destructor de la classe
CkeFIFOList::~CkeFIFOList()
	{
	// La classe LIFO ja esborra tots els elements
	}

// **************************************************************************
// Afegeix un element a la llista
// Com a entrada ha de rebre:
// Item	   	- Element a afegir
VOID CkeFIFOList::Add( PCkeListItem pItem )
	{
	DWORD flags = CLI();

	pItem->SetNext( NULL ); // Per si no s'ha fet
	dwelements++; // Un element ms

	if( plast ) // Si ja hi ha elements a la llista, el segent de l'ltim s el nou
		plast->SetNext( pItem );
	else // No hi ha elements a la llista
		pfirst = pItem;

	// Per llistes doblement encadenades
	if( pItem->ClassCheck( CID_DblListItem ) )
		((PCkeDblListItem) pItem)->SetPrev( (PCkeDblListItem) plast );

	plast = pItem; // El nou ltim

	STI( flags );
	}

// **************************************************************************
// Treu un element de la llista sense esborrar-lo realment
// Com a entrada ha de rebre:
// Item	   	- Element a eliminar
VOID CkeFIFOList::Delete( PCkeListItem pItem )
	{
	DWORD flags = CLI();

	if( pfirst ) // Si ja hi ha algun element a la llista
		{
		if( pfirst == pItem ) // Volem eliminar el primer
			{
			pfirst = pItem->GetNext(); // El nou primer

			if( pfirst->ClassCheck( CID_DblListItem ) ) // Per a llistes doblement encadenades
				((PCkeDblListItem) pfirst)->SetPrev( NULL );
			}
		else // No s el primer
			{
			if( pItem->ClassCheck( CID_DblListItem ) )
				{ // Per a llistes doblement encadenades, s simple
				(((PCkeDblListItem) pItem)->GetPrev())->SetNext( pItem->GetNext() );
				((PCkeDblListItem) pItem->GetNext())->SetPrev( ((PCkeDblListItem) pItem)->GetPrev() );
				}
			else // Per a llistes amb encadenat simple s ms costs
				{
				PCkeListItem pelem = pfirst;
				// Cerquem l'anterior al que volem extreure
				while( pelem->GetNext() != pItem && pelem->GetNext() )
					pelem = pelem->GetNext();

				if( pelem->GetNext() == pItem ) // Si l'hem trobat, el treem
					{
					pelem->SetNext( pItem->GetNext() );

					if( pItem == plast ) // Si era l'ltim, hem de posar un nou ltim
						plast = pelem;
					}
				}
			}

		dwelements--; // Un element menys
		}

	STI( flags );
	}

