/* **************************************************************************
*                                                                           *
*  Mem.CPP                                                                  *
*                                                                           *
*  12-03-97                                                    BUILD:0002   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Funcions estndard de gesti de memria per a C/C++                      *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "kernel\mem.h"
#include "kernel\system.h"
#include "string.h"
#include "kernel\asm.h"

extern PCkeSystem System;
BOOL bSpecialMemory = FALSE; // Hi ha situacions especials per al tractament de memria

// **************************************************************************
// Operador new global - funci estndard del C++
// Com a entrada ha de rebre:
// Type_size	- Tamany de l'objecte en 'bytes'
void * operator new( size_t Type_size)
	{
	return malloc( Type_size );
	}

// **************************************************************************
// Operador delete global - funci estndard del C++
// Com a entrada ha de rebre:
// ptr			- Adrea de l'objecte que volem eliminar
void operator delete( void *ptr )
	{
	free( ptr );
	}

// **************************************************************************
// Reserva un cert nombre de 'bytes' en un 'heap'. Retorna l'adrea cap a la zona reservada
// Com a entrada ha de rebre:
// Size			- Nombre de 'bytes' a reservar
PVOID malloc( DWORD dwSize )
	{
	DWORD flags = CLI();

	PCkeHeap Heap; // Necessitem un 'heap'

	if( System->Running() && !bSpecialMemory ) // Si estem executant una aplicaci i no requerim memria especial
		Heap = ((System->Running())->Process())->Heap(); // El 'heap' s el de l'aplicaci en execuci
	else
		Heap = System->Heap(); // El 'heap' s el del sistema

	PTHeapItem Item = Heap->GetFirstItem(); // Obtenim el primer element del 'heap'

	BOOL found = FALSE; // Encara no hem trobat espai

	while( !found && Item != NULL )
		{
		if( Item->Type == HEAP_FREE && Item->dwSize >= dwSize )
			{
			found = TRUE; // Hem trobat un element lliure prou gran per a la reserva

			if( Item->dwSize > dwSize + sizeof( THeapItem ) )
				{ // Hi ha espai per a un element nou -> l'hem de crear
				PTHeapItem New = (PTHeapItem) ((PBYTE) Item + dwSize + sizeof( THeapItem ));
				New->pPrev = Item;
				New->pNext = Item->pNext;
				Item->pNext = New;
				New->Type = HEAP_FREE; // El nou element estar lliure
				New->dwSize = Item->dwSize - dwSize - sizeof( THeapItem );
				}

			Item->Type = HEAP_USER; // L'element trobat s utilitzat
			Item->dwSize = dwSize;
			}
		else
			Item = Item->pNext; // Mentre no en trobem un, passem al segent
		}
	STI( flags );

	if( found ) // Hem trobat un espai
		return (PVOID) ((PBYTE) Item + sizeof( THeapItem ));
	else	// No hi ha espai lliure
		return NULL;
	}

// **************************************************************************
// Allibera una zona de memria anteriorment reservada
// Com a entrada ha de rebre:
// Pointer		- Apuntador cap a la zona de memria reservada
VOID free( PVOID pPointer )
	{
	CHAR str[ 80 ];

	if( pPointer == NULL )
		return; // L'apuntador s NULL

	DWORD flags = CLI();

	// Obtenim l'apuntador cap a l'element
	PTHeapItem Item = (PTHeapItem) ((PBYTE) pPointer - sizeof( THeapItem ));

	if( Item->Type != HEAP_FREE ) // Si no est lliure l'element
		{
		Item->Type = HEAP_FREE; // Ara ja estar lliure
		if( Item->pPrev ) // Comprovem si l'anterior...
			{
			if( Item->pPrev->Type == HEAP_FREE ) // ...tamb est lliure
				{
				PTHeapItem Prev = Item->pPrev; // Els unim
				Prev->pNext = Item->pNext;
				Prev->dwSize += Item->dwSize + sizeof( THeapItem );
				Item = Prev;
				}
			}
		if( Item->pNext ) // Comprovem si el segent...
			{
			if( Item->pNext->Type == HEAP_FREE ) // ...tamb est lliure
				{
				PTHeapItem Next = Item->pNext; // Els unim
				Item->pNext = Next->pNext;
				Item->dwSize += Next->dwSize + sizeof( THeapItem );
				}
			}
		}
	else // Hem intentat alliberar ms d'un cop un element
		{
		sprintf( str, TEXT( "ERROR - free (%08x) -> Thread %08x, CR3 %08x" ), pPointer, System->Running(), GetCR3() );
		TRACE( str );
		(System->Debug())->MemoryDump( (PBYTE) ((DWORD) pPointer - 0x10), 0x20 );
		}

	STI( flags );
	}

