/* **************************************************************************
*                                                                           *
*  ObjDir.CPP                                                               *
*                                                                           *
*  29-01-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classe per al control dels directori d'objectes                          *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "kernel\objdir.h"
#include "string.h"
#include "errors.h"
#include "kernel\asm.h"
#include "kernel\system.h"

// **************************************************************************
// Constructor de la classe
// Com a entrada ha de rebre:
// Parent  	- Apuntador cap al pare d'aquest directori
// Name    	- Cadena de carcters amb el nom del directori
// Temp    	- Indica si el directori s temporal
CkeObjectDirectory::CkeObjectDirectory( PCkeObject pParent, PSTR sName, BOOL bTemp ) : CkeObject( pParent, sName, bTemp )
	{
	id = CID_ObjectDirectory;

	pchild = NULL;
	}

// **************************************************************************
// Destructor de l'objecte
CkeObjectDirectory::~CkeObjectDirectory()
	{
	while( pchild )
		{
		PCkeObject pnext = (PCkeObject) pchild->GetNext();
		delete( pchild );	// ha d'esborrar tots els fills i els nets...
		pchild = pnext;
		}
	}

// **************************************************************************
// Indica si la classe de l'objecte s o no la que es passa com a parmetre
// Com a entrada ha de rebre:
// Cuid     	- Identificador de la classe
BOOL CkeObjectDirectory::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_ObjectDirectory )
		return TRUE;
	else
		return CkeObject::ClassCheck( Cuid );
	}

// **************************************************************************
// Retorna l'objecte que s'est cercant
// Com a entrada ha de rebre:
// Name	    	- Nom de l'objecte que es vol trobar
PCkeObject CkeObjectDirectory::Analysis( PSTR sName )
	{
#ifdef _DEBUG
	CHAR str[ 80 ];

	if( DebugLevel > 34 )
		{
		sprintf( str, TEXT( "Analysis( %s -%08x- ) cap a %s" ), sName, (DWORD) sName, sname );
		TRACE( str );
		}
#endif
	if( !sName )
		return NULL; // Si el nom s nul, no existeix l'objecte

	// Separem la primera part del nom: xxx\\yyy -> xxx
	PSTR Point = strchr( sName, '\\' );

	if( Point ) // El nom t ms d'una part
		{
		*Point = '\000';

		// Si el nom comena amb '\\'
		if( strlen( sName ) == 0 )
			{
			// Seguim la cadena fins a l'arrel
			if( strcmp( sname, TEXT( "\\" ) ) )
				return pparent->Analysis( sName );
			else // Ja estem en l'arrel
				{
				if( strlen( sName + 1 ) == 0 ) // Si el nom era: "\\"
					return this; // Ja l'hem trobat
				else // Si contenia ms carcters, seguim buscant
					return Analysis( sName + 1 );
				}
			}

		// El nom no comena amb "\\"
		DWORD flags = CLI();

		PCkeObject obj = pchild; // Comprovem si el primer fill concorda amb el demanat
		BOOL found = FALSE;

		if( obj )
			found = (strcmp( obj->Name(), sName ) == 0 ? TRUE : FALSE);

		while( obj && !found ) // Mentre no el trobem
			{
			obj = (PCkeObject) obj->GetNext(); // Anem al germ

			if( obj )
				found = (strcmp( obj->Name(), sName ) == 0 ? TRUE : FALSE);
			}

		STI( flags );

		if( found ) // L'hem trobat
			{
			*Point = '\\'; // Restaurem el carcter modificat
			Point++; // Passem a la part segent del nom

			if( strlen( Point ) ) // El nom continua: hem de seguir analitzant
				return obj->Analysis( Point );
			else
				return this; // El nom s'ha acabat
			}
		else // No hem pogut trobar l'objecte
			{
#ifdef _DEBUG
			CHAR str[ 80 ];

			sprintf( str, TEXT( "OBJECT NOT FOUND( %s -%08x- ) a %s" ), sName, (DWORD) sName, sname );
			TRACE( str );
#endif
			}
		}
	else // El nom no cont '\\' -> xxx (ja s final)
		{
		DWORD flags = CLI();

		PCkeObject obj = pchild;
		BOOL found = FALSE;

		if( obj )
			found = (strcmp( obj->Name(), sName ) == 0 ? TRUE : FALSE);

		while( obj && !found ) // Mentre no el trobem
			{
			obj = (PCkeObject) obj->GetNext(); // Anem al germ
			if( obj )
				found = (strcmp( obj->Name(), sName ) == 0 ? TRUE : FALSE);
			}

		STI( flags );
		// Si concorda amb algun dels fills, el retornem, sin, NULL
		if( found )
			return obj;
		}

	return NULL;
	}

// **************************************************************************
// Retorna el primer objecte fill del directori
PCkeObject CkeObjectDirectory::FirstChild()
	{
	return pchild;
	}

// **************************************************************************
// Afegeix un nou objecte al directori
// Com a entrada ha de rebre:
// Object   	- Apuntador a l'objecte que es vol afegir
VOID CkeObjectDirectory::AddChild( PCkeObject pObject )
	{
	pObject->SetPrev( NULL );

	DWORD flags = CLI();

	pObject->SetNext( pchild ); // El segent ser l'actual primer

	if( pchild ) // Si ja hi ha algun objecte, l'enllacem
		pchild->SetPrev( pObject );

	pchild = pObject; // El nou ser el primer

	STI( flags );
	}

// **************************************************************************
// Esborra el fill que se li passa com a parmetre
// Com a entrada ha de rebre:
// Object   	- Apuntador a l'objecte que es vol esborrar
VOID CkeObjectDirectory::DeleteChild( PCkeObject pObject )
	{
	if( pObject == pchild ) // Si s el primer, hem de fer canvi de primer
		{
		pchild = (PCkeObject) pchild->GetNext(); // El segon ser el primer

		if( pchild )
			{
			pchild->SetPrev( NULL );
			pObject->SetNext( NULL );
			}
		}

	delete pObject;
	}

// **************************************************************************
// Esborra el fill que se li passa com a parmetre
// Com a entrada ha de rebre:
// Name	    	- Nom de l'objecte que es vol esborrar
VOID CkeObjectDirectory::DeleteChild( PSTR sName )
	{
	PCkeObject pObject = Analysis( sName ); // Obtenim l'apuntador a l'objecte

	if( (System->Running())->ErrorCode() == OK ) // Si s'ha trobat...
		DeleteChild( pObject ); // ...l'esborrem
	}

