/* **************************************************************************
*                                                                           *
*  Region.CPP                                                               *
*                                                                           *
*  24-01-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Regi de memria en forma de recurs                                      *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "kernel\region.h"
#include "errors.h"
#include "kernel\system.h"

// **************************************************************************
// Constructor de la classe
// Com a entrada ha de rebre:
// pVAD     	- Apuntador al primer dels VADs (pot ser NULL)
// Size     	- Tamany de la regi
// Flags    	- 'Flags' de protecci
CkeRegion::CkeRegion( PCkeVAD pVAD, DWORD dwSize, BYTE cProtection, PCkeObject pParent, PSTR sName, BOOL bTemp ) : CkeResource( pParent, sName, bTemp )
	{
	id = CID_Region;

	pvad = pVAD;
	dwvirtualsize = dwSize;
	cprotection = cProtection;
	}

// **************************************************************************
// Destructor de la classe
CkeRegion::~CkeRegion()
	{
// Ha de destruir tots els VADs -BUG
	}

// **************************************************************************
// Indica si la classe de l'objecte es o no la que es passa com a parametre
// Com a entrada ha de rebre:
// Cuid     	- Identificador de la classe
BOOL CkeRegion::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_Region )
		return TRUE;
	else
		return CkeResource::ClassCheck( Cuid );
	}

// **************************************************************************
// Retorna l'objecte de la primera VAD de la regi
PCkeVAD CkeRegion::FirstVAD()
	{
	return pvad;
	}

// **************************************************************************
// Selecciona l'objecte de la primera VAD de la regi
VOID CkeRegion::FirstVAD( PCkeVAD pVAD )
	{
	pvad = pVAD;
	}

// **************************************************************************
// Retorna el tamany de la regi
DWORD CkeRegion::VirtualSize()
	{
	return dwvirtualsize;
	}

// **************************************************************************
// Retorna l'indicador de si la regi es accessible en mode usuari o no
BOOL CkeRegion::UserRegion()
	{
	return (BOOL)(cprotection & REGION_USER);
	}

// **************************************************************************
// Retorna l'indicador de si la regi es modificable o no
BOOL CkeRegion::WriteableRegion()
	{
	return (BOOL)(cprotection & REGION_WRITE);
	}

