/* **************************************************************************
*                                                                           *
*  Selector.CPP                                                             *
*                                                                           *
*  13-07-96                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classe per al control dels selectors                                     *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "kernel\selector.h"
#include "errors.h"
#include "kernel\system.h"

// **************************************************************************
// Constructor de la classe
// Com a entrada ha de rebre:
// sel      	- Selector
CSelector::CSelector( WORD sel ) : CkeType( CID_Selector )
	{
	Selector( sel );
	}

// **************************************************************************
// Destructor de la classe
CSelector::~CSelector()
	{
	}

// **************************************************************************
// Indica si la classe de l'objecte s o no la que es passa com a parmetre
// Com a entrada ha de rebre:
// Cuid     	- Identificador de la classe
BOOL CSelector::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_Selector )
		return TRUE;
	else
		return CkeType::ClassCheck( Cuid );
	}

// **************************************************************************
// Carrega un nou selector
// Com a entrada ha de rebre:
// sel      	- Nou selector
VOID CSelector::Selector( WORD sel )
	{
	selector.Word.Index 	= sel;
	}

// **************************************************************************
// Retorna el selector carregat
WORD CSelector::Selector()
	{
	return selector.Word.Index;
	}

// **************************************************************************
// Retorna l'index del selector
WORD CSelector::Index()
	{
	return selector.Word.Bits.Index;
	}

// **************************************************************************
// Retorna l'indicador de GDT
BOOL CSelector::GDT()
	{
	return (BOOL) (selector.Word.Bits.Table ? SELECTOR_GDT : SELECTOR_LDT);
	}

// **************************************************************************
// Retorna l'indicador de LDT
BOOL CSelector::LDT()
	{
	return selector.Word.Bits.Table;
	}

// **************************************************************************
// Retorna l'indicador de RPL
BYTE CSelector::RPL()
	{
	return selector.Word.Bits.RPL;
	}

// **************************************************************************
// Modifica l'index del selector
// Com a entrada ha de rebre:
// i        	- Nou index
VOID CSelector::Index( WORD i )
	{
	selector.Word.Bits.Index	= i;
	}

// **************************************************************************
// Modifica la taula del selector
// Com a entrada ha de rebre:
// t        	- Taula: (1) LDT (0) GDT
VOID CSelector::Table( BOOL t )
	{
	selector.Word.Bits.Table	= t;
	}

// **************************************************************************
// Modifica l'RPL del selector
// Com a entrada ha de rebre:
// l        	- Nou RPL
VOID CSelector::RPL( BYTE l )
	{
	selector.Word.Bits.RPL	= l;
	}

