/* **************************************************************************
*                                                                           *
*  SymLink.CPP                                                              *
*                                                                           *
*  13-07-96                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Control dels enllaos simblics en el directori d'objectes               *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "kernel\symlink.h"
#include "errors.h"
#include "kernel\system.h"
#include "kernel\mem.h"
#include "string.h"
#include "kernel\asm.h"

// **************************************************************************
// Constructor de la classe
CkeSymbolicLink::CkeSymbolicLink( PCkeObject pParent, PSTR sName, BOOL bTemp ) : CkeObject( pParent, sName, bTemp )
	{
	id = CID_SymbolicLink;
	}

// **************************************************************************
// Destructor de la classe
CkeSymbolicLink::~CkeSymbolicLink()
	{
	}

// **************************************************************************
// Indica si la classe de l'objecte es o no la que es passa com a parametre
// Com a entrada ha de rebre:
// Cuid     	- Identificador de la classe
BOOL CkeSymbolicLink::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_SymbolicLink )
		return TRUE;
	else
		return CkeObject::ClassCheck( Cuid );
	}

// **************************************************************************
// Retorna el nom al que fa referencia l'enlla
PSTR CkeSymbolicLink::NewName()
	{
	return snewname;
	}

// **************************************************************************
// Modifica el nom al que fa referencia l'enlla
// Com a entrada ha de rebre:
// NewName   	- Nou nom
VOID CkeSymbolicLink::NewName( PSTR sNewName )
	{
	snewname = sNewName;
	}

// **************************************************************************
// Transforma el nom que es passa com a parmetre en el nom de l'objecte al que fa referncia l'enlla dinmic
// Com a entrada ha de rebre:
// Param     	- Nom que es vol analitzar
PCkeObject CkeSymbolicLink::Analysis( PSTR sParam )
	{
	DWORD flags = CLI();
	PSTR str = (PSTR) malloc( strlen( snewname ) + strlen( sParam ) + 2 * sizeof( CHAR ) );
	sprintf( str, TEXT( "%s\\%s" ), snewname, sParam ); // Fem el canvi de nom
	STI( flags );

	PCkeObject pObj = System->FindObject( str ); // En comencem la cerca

	free( str ); // !!!!!
	
	return pObj;
	}

