/* **************************************************************************
*                                                                           *
*  SysTable.CPP                                                             *
*                                                                           *
*  13-07-96                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classe genrica per a les taules GDT, LDT i IDT                          *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "kernel\systable.h"
#include "errors.h"
#include "kernel\system.h"
#include "kernel\asm.h"

// **************************************************************************
// Constructor de la classe
// Com a entrada ha de rebre:
// Desc  	  	- Apuntador al primer descriptor de la taula
// Size     	- Tamany de la taula
CSystemTable::CSystemTable( PTDescriptor pDesc, WORD wSize ) : CkeType( CID_SystemTable )
	{
	Table( pDesc, wSize );
	}

// **************************************************************************
// Destructor de la classe
CSystemTable::~CSystemTable()
	{
	}

// **************************************************************************
// Indica si la classe de l'objecte s o no la que es passa com a parmetre
// Com a entrada ha de rebre:
// Cuid     	- Identificador de la classe
BOOL CSystemTable::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_SystemTable )
		return TRUE;
	else
		return CkeType::ClassCheck( Cuid );
	}

// **************************************************************************
// Selecciona una nova taula
// Com a entrada ha de rebre:
// Desc  	  	- Apuntador al primer descriptor de la taula
// Size     	- Tamany de la taula
VOID CSystemTable::Table( PTDescriptor pDesc, WORD wSize )
	{
	pdesc = pDesc;
	wsize = wSize;
	binitialized = (pdesc == NULL ? FALSE : TRUE);
	}

// **************************************************************************
// Retorna el primer descriptor de la taula
PTDescriptor CSystemTable::GetTable()
	{
	return pdesc;
	}

// **************************************************************************
// Retorna el descriptor n de la taula
// Com a entrada ha de rebre:
// Index    	- Index del descriptor
PTDescriptor CSystemTable::Descriptor( WORD wIndex )
	{
	return &(pdesc[ wIndex ]);
	}

// **************************************************************************
// Retorna el tamany de la taula
WORD CSystemTable::Size()
	{
	return wsize;
	}

// **************************************************************************
// Retorna el nombre de descriptors lliures dins la taula
WORD CSystemTable::Free()
	{
	WORD wCount = 0, wIndex;

	DWORD flags = CLI();

	for( wIndex = 0; wIndex < wsize; wIndex++ )
		{
		PCDescriptor Desc = new CDescriptor( &(pdesc[ wIndex ]) );

// Quan un descriptor est ocupat, es fa present.
// Quan un descriptor est lliure, es fa no present.
		if( !Desc->Present() )
			wCount++;

		delete Desc;
		}

	STI( flags );

	return wCount;
	}

// **************************************************************************
// Modifica el tamany de la taula
// Com a entrada ha de rebre:
// Size     	- Nou tamany de la taula
VOID CSystemTable::Size( WORD wSize )
	{
	wsize = wSize;
	}

// **************************************************************************
// Allibera el descriptor n
// Com a entrada ha de rebre:
// Index    	- Descriptor a alliberar
VOID CSystemTable::Free( WORD wIndex )
	{
	PCDescriptor Desc = new CDescriptor( &(pdesc[ wIndex ]) );

	DWORD flags = CLI();

// Quan un descriptor est ocupat, es fa present.
// Quan un descriptor est lliure, es fa no present.
	if( Desc->Present() )
		{
		Desc->Present( FALSE );
		SETERRORCODE( OK );
		}
	else
		SETERRORCODE( DESC_ALREADYFREE );

	STI( flags );

	delete Desc;
	}

// **************************************************************************
// Construeix un nou descriptor (l'ocupa)
// Com a entrada ha de rebre:
// Index    	- Index del nou descriptor (pot ser NEXT_DESCRIPTOR)
WORD CSystemTable::CreateDescriptor( WORD wIndex )
	{
	SETERRORCODE( OK );

	if( wIndex == NEXT_DESCRIPTOR ) // Volem cercar el primer lliure
		{
		PCDescriptor Desc = new CDescriptor( pdesc );

// Quan un descriptor est ocupat, es fa present.
// Quan un descriptor est lliure, es fa no present.
		WORD wCount = 0;
		DWORD flags = CLI();

		while( wCount < wsize && Desc->Present() ) // Cerquem el primer no present
			{
			wCount++;
			Desc->Descriptor( &(pdesc[ wCount ]) );
			}

		if( Desc->Present() )
			SETERRORCODE( DESC_NOFREESPACE ); // Tots ocupats
		else
			{
			wIndex = wCount; // N'hem trobat un, el preparem
			Desc->Descriptor( &(pdesc[ wCount ]) );
			Desc->Clear();
			Desc->Present( TRUE );

			SETERRORCODE( OK );
			}

		STI( flags );
		delete Desc;
		}
	else // Ens demanen un descriptor concret
		{
		PCDescriptor Desc = new CDescriptor( &(pdesc[ wIndex ]) );

		DWORD flags = CLI();
// Quan un descriptor est ocupat, es fa present.
// Quan un descriptor est lliure, es fa no present.
		if( Desc->Present() )
			SETERRORCODE( DESC_ALREADYMADE ); // Ja est ocupat
		else
			{
			Desc->Clear(); // Incialitzem el descriptor
			Desc->Present( TRUE ); // El fem present -> ocupat
			SETERRORCODE( OK );
			}

		STI( flags );
		delete Desc;
		}

	return wIndex;
	}

