/* **************************************************************************
*                                                                           *
*  System.CPP                                                               *
*                                                                           *
*  13-05-97                                                    BUILD:0010   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classe que controla la informaci principal del sistema                  *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "kernel\system.h"
#include "kernel\pat.h"
#include "errors.h"
#include "kernel\tpags.h"
#include "kernel\page.h"
#include "common.h"
#include "string.h"
#include "kernel\mem.h"
#include "kernel\asm.h"
#include "kernel\interrup.h"
#include "kernel\trapgate.h"
#include "kernel\intgate.h"
#include "kernel\taskgate.h"
#include "kernel\selector.h"
#include "kernel\kernel.h"

// *********************************** DEFINES
#ifdef _DEBUG
#define _VER	TEXT( "0.01" )
#else
#define _VER	TEXT( "1.00" )
#endif

#define _BUILD	18

// *********************************** GLOBALS
extern PCkeKernel _export Kernel;
extern WORD tsssel, idletask;
extern TRegisters int_regs;
#ifdef _DEBUG
extern DWORD DebugLevel;
#endif
BOOL CkeSystem::bmade = FALSE;	// Noms permetrem la creaci d'un objecte 'CkeSystem'
PTDescriptor gdtentries = (PTDescriptor) GDT_OFFSET; // Adrea on comena la GDT
PTDescriptor idtentries = (PTDescriptor) IDT_OFFSET; // Adrea on comena l'IDT

// **************************************************************************
// Constructor de la classe (nomes s'en crea una instancia)
CkeSystem::CkeSystem() : CkeType( CID_System )
	{
// Noms es permet una instncia d'aquesta classe
	if( bmade )
		{
		SETERRORCODE( SYS_ALREADYMADE );
		return;
		}

	bmade = TRUE;	// Indiquem que l'objecte ja s'ha creat
	System = this;	// Inicialitzem l'apuntador global

// Hem d'inicialitzar totes les estructures de dades necessries:
	dwerror = OK;
	dwtimertick = 0;

// Llistes de fluxos (i flux en execuci)
	prun = NULL;
	pall = NULL;
	pready = NULL;

	{	// Presentem un missatge per pantalla
	syscon.Clear();
	CHAR str[ 80 ];
	sprintf( str, TEXT( "Kernel Module ver %s (Build %3u) Date: %s\r\n" ), _VER, _BUILD, TEXT( __DATE__ ) );
	syscon.OutText( str );
	}

// Hem d'inicialitzar la taula virtual d'interrupcions
	for( DWORD index = 0; index < MAX_VIRTUAL_INT; index++ )
		dwvinttable[ index ] = NULL;

// PhysicalMemorySize (dwphysicalmem)
	PDWORD memsize = (PDWORD) 0x7fffcL; // DOSLoad hi deixa el tamany en bytes
	dwphysicalmem = *memsize;

	dwmachinetype = CpuType();	// Mquina sobre la que estem executant-nos

// PAT (Physical Allocation Table)
	initPAT();
// Preparem el 'Heap' del sistema
	initHEAP();
// GDT
	pgdt = new CGDT( gdtentries, GDT_ENTRIES );
//	IDT
	initIDT();
// La pgina 0 de memria virtual no estar mapejada, per tal de detectar apuntadors a NULL
	{
	CTPage PageDir16( (PTPage) 0x80000L ); // Directori de pgines
	CPage SpecialPage( PageDir16.Page( 0 ) );
	CTPage SpecialTable( (PTPage) SpecialPage.PageAddress() ); // Taula de pgines

	SpecialPage.Page( SpecialTable.Page( 0 ) ); // Pgina 0
	SpecialPage.Writeable( FALSE );
	SpecialPage.Present( FALSE );
	CacheCR3(); // Quan passem una pgina de present a no present, hem de buidar la 'cache' del processador
	}

// Directori arrel dels objectes
	pobjdir = new CkeObjectDirectory( NULL, TEXT( "\\" ) );
// Llista de fluxos ordenats
	pready = new CkeThreadList();

// Inicialitzem l'AAL
	paal = new CaalAAL();
	}

// **************************************************************************
// Destructor de la classe (no s'arriba a destruir mai)
CkeSystem::~CkeSystem()
	{
	TRACE( TEXT( "BUG CkeSystem::~CkeSystem cridat BUG!!!!!" ) );
	}

// **************************************************************************
// Indica si la classe de l'objecte es o no la que es passa com a parametre
// Com a entrada ha de rebre:
// Cuid     	- Identificador de la classe
BOOL CkeSystem::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_System )
		return TRUE;
	else
		return CkeType::ClassCheck( Cuid );
	}

// **************************************************************************
// Inicialitza la PAT de 32 'bits' del sistema
VOID CkeSystem::initPAT()
	{
	CkePAT PAT16( PAT16_OFFSET, PAT16_SIZE, TRUE );	// Est en una posici concreta del 1er. MB

	CTPage PageDir16( (PTPage) PAGEDIR32_OFFSET ); // Cerquem el directori de pgines creat per DOSLoad

	DWORD PhysicalPages = dwphysicalmem >> PAGE_BITS;
	DWORD PATSize = PhysicalPages * sizeof( TPAT );
	DWORD PATPages = PATSize >> PAGE_BITS;
	BYTE PageTables = (BYTE) (PATPages / PAGETABLE_ENTRIES);

// PageTables est entre 0 i 4, per 0 s un valor no vlid
	if( PageTables == 0 )
		PageTables++;

	for( BYTE table = 0; table < PageTables; table++ )
		{
// Creem les taules de pgines per a les pgines de la PAT
// Cerquem l'entrada corresponent a la PAT32
		CPage Page16( PageDir16.Page( (WORD) ((PAT_REGION_ADDR >> PAGE_BITS) / PAGETABLE_ENTRIES + table) ) );

		DWORD physpage = PAT16.AllocPage( SYSTEM_PAGE, NULL, NULL, NULL, 0L, TRUE );

		Page16.Writeable( TRUE );
		Page16.User( FALSE );
		Page16.COW( FALSE );
		Page16.Readable( TRUE );
		Page16.Executable( FALSE );
		Page16.PageAddress( physpage );
		Page16.Present( TRUE );

		DWORD logpage = MapPT( physpage, &PAT16 );	// Mapegem la pgina que acabem de reservar

		CTPage PageTable32( (PTPage) logpage );

// Inicialitzem cada entrada de la taula de pgines
		for( WORD count = 0; count < PAGETABLE_ENTRIES && PATPages; count++, PATPages-- )
			{
			PTPage PTE = PageTable32.Page( count );
			CPage Page32( PTE );

			PAT16.AllocPage( SYSTEM_PAGE, PTE, PAT_REGION_ADDR + ((DWORD) table << 22) + ((DWORD) count << PAGE_BITS), NULL, NULL, TRUE );

			Page32.Writeable( TRUE );
			Page32.Readable( TRUE );
			}
		}

	static CkePAT PAT( PAT_REGION_ADDR, PATSize );	// Creem la PAT32

	PDWORD pPAT16 = (PDWORD) PAT16_OFFSET;
	PDWORD pPAT32 = (PDWORD) (PAT_REGION_ADDR + 4096); // Els primers 4096 de la PAT16 no existeixen, sabem que aquella zona est reservada

// Inicialitzem les 256 primeres entrades
	PTPAT fakepat = (PTPAT) PAT_REGION_ADDR;
	for( DWORD total = 0L; total < 256; total++ )
		fakepat[ total ].cOwner = RESERVED_PAGE;
// Copiem la PAT16
	for( DWORD total = 0L; total < (PATSize < PAT16_SIZE ? PATSize : PAT16_SIZE) / sizeof( DWORD ); total++ )
		pPAT32[ total ] = pPAT16[ total ];

	ppat = (PCkePAT) &PAT;
	}

// **************************************************************************
// Inicialitza el 'Heap' del sistema
VOID CkeSystem::initHEAP()
	{
	CTPage PageDir16( (PTPage) PAGEDIR32_OFFSET ); // Cerquem el directori de pgines creat per DOSLoad
// Preparem la taula de pgines
	CPage PageEntry( PageDir16.Page( (WORD) ((SYSHEAP_REGION_ADDR >> PAGE_BITS) >> 10) ) );

	DWORD physpage = ppat->AllocPage( SYSTEM_PAGE, NULL, NULL, NULL, 0L, TRUE );

	PageEntry.Writeable( TRUE );
	PageEntry.User( FALSE );
	PageEntry.COW( FALSE );
	PageEntry.Readable( TRUE );
	PageEntry.Executable( FALSE );
	PageEntry.PageAddress( physpage );
	PageEntry.Present( TRUE );

	DWORD logpage = MapPT( physpage );	// Mapegem la taula de pgines

	CTPage PageTable32( (PTPage) logpage );

	for( DWORD count = 0; count < (SYSHEAP_REGION_SIZE >> PAGE_BITS); count++ )
		{
		CPage Page32( PageTable32.Page( (WORD) count ) );
		// Reservem les pgines necessries per al 'heap'
		ppat->AllocPage( SYSTEM_PAGE, PageTable32.Page( (WORD) count ), SYSHEAP_REGION_ADDR + (count << PAGE_BITS), NULL, 0L, TRUE /* o FALSE? -BUG */);

//		Page32.Writeable( TRUE );
		Page32.Readable( TRUE );
		}

	PTHeapItem HeapItem = (PTHeapItem) SYSHEAP_REGION_ADDR; // Creem el HeapItem

	HeapItem->Type = HEAP_FREE;	// Tot lliure
	HeapItem->dwSize = SYSHEAP_REGION_SIZE - sizeof( THeapItem );
	HeapItem->pPrev = HeapItem->pNext = NULL;

	static CkeHeap Heap( HeapItem, SYSHEAP_REGION_SIZE ); //	Creem el Heap

	psysheap = &Heap;
	}

// **************************************************************************
// Inicialitza la IDT de 32 'bits' del sistema
VOID CkeSystem::initIDT()
	{
	pidt = new CIDT( idtentries, IDT_ENTRIES );
	pidt->Clear();	// Esborrem l'IDT

// Desprs d'inicialitzar tota la taula en general...
// ...passem a inicialitzar zones concretes
//	CIntGate intgate; // Bloquejar les interrupcions
//	CTrapGate trapgate; // NO bloquejar les interrupcions
	WORD OSCode;

	{
	CSelector selector;	// Preparem el selector de codi
	selector.Index( 1 );
	selector.RPL( 0 );
	selector.Table( SELECTOR_GDT );
	OSCode = selector.Selector();
	}

	CIntGate intgate( pidt->Descriptor( SYSINT_DIVISION ) );
	intgate.Selector( OSCode );
	intgate.Offset( (DWORD) INT0 );

	intgate.Descriptor( pidt->Descriptor( SYSINT_TRAP ) );
	intgate.Selector( OSCode );
	intgate.Offset( (DWORD) INT1 );

	intgate.Descriptor( pidt->Descriptor( SYSINT_NMI ) );
	intgate.Selector( OSCode );
	intgate.Offset( (DWORD) INT2 );

	intgate.Descriptor( pidt->Descriptor( SYSINT_DEBUG ) );
	intgate.Selector( OSCode );
	intgate.Offset( (DWORD) INT3 );

	intgate.Descriptor( pidt->Descriptor( SYSINT_OVERFLOW ) );
	intgate.Selector( OSCode );
	intgate.Offset( (DWORD) INT4 );

	intgate.Descriptor( pidt->Descriptor( SYSINT_BOUND ) );
	intgate.Selector( OSCode );
	intgate.Offset( (DWORD) INT5 );

	intgate.Descriptor( pidt->Descriptor( SYSINT_OPCODE ) );
	intgate.Selector( OSCode );
	intgate.Offset( (DWORD) INT6 );

	intgate.Descriptor( pidt->Descriptor( SYSINT_MATHPROCESSOR ) );
	intgate.Selector( OSCode );
	intgate.Offset( (DWORD) INT7 );

	intgate.Descriptor( pidt->Descriptor( SYSINT_DOUBLEFAULT ) );
	intgate.Selector( OSCode );
	intgate.Offset( (DWORD) INT8 );

	intgate.Descriptor( pidt->Descriptor( SYSINT_MATHPROCSEGMENT ) );
	intgate.Selector( OSCode );
	intgate.Offset( (DWORD) INT9 );

	{	// La interrupci 0xA necessita ser tractada en una altra tasca
	WORD OSData;

	{
	CSelector selector; // Preparem el selector de dades
	selector.Index( 2 );
	selector.RPL( 0 );
	selector.Table( SELECTOR_GDT );
	OSData = selector.Selector();
	}

	WORD index = pgdt->CreateDescriptor();	// Necessitem un descriptor per al TSS
	PTDescriptor ptdesc = pgdt->Descriptor( index );
	CDescriptor desc( ptdesc );
	WORD tsssize = (WORD) sizeof( TTSS );
	DWORD tssbase = (DWORD) malloc( tsssize );
	desc.Base( tssbase );
	desc.Limit( tsssize - 1 );
	desc.Granularity( FALSE );
	desc.Present( TRUE );

	PCTSS ptss = new CTSS( ptdesc );
	ptss->Clear();	// Preparem el nou TSS

	ptss->Set( TSS_FREE );
	ptss->PDBR( PAGEDIR32_OFFSET );
	ptss->SetCSEIP( OSCode, (DWORD) INTA );
	ptss->EFLAGS( 0x202 );
	ptss->ES( OSData );
	ptss->DS( OSData );
	ptss->FS( OSData );
	ptss->GS( OSData );
	ptss->LDT( NULL );
	ptss->IOMap( (WORD) 0xffff );

// Preparem una pila per al flux
	ptss->SetSSESP( OSData, (DWORD) 0x70000 + (2 * PAGE_SIZE - 1) );
	ptss->SetStack( 0, OSData, (DWORD) 0x70000 + (2 * PAGE_SIZE - 1) );

	CSelector selTask;	// Preparem el selector per al TSS
	selTask.Index( index );
	selTask.RPL( 0 );
	selTask.Table( SELECTOR_GDT );
	CTaskGate taskgate( pidt->Descriptor( SYSINT_BADTSS ) );
	taskgate.Selector( selTask.Selector() );
	}

	intgate.Descriptor( pidt->Descriptor( SYSINT_SEGMENT ) );
	intgate.Selector( OSCode );
	intgate.Offset( (DWORD) INTB );

	intgate.Descriptor( pidt->Descriptor( SYSINT_STACK ) );
	intgate.Selector( OSCode );
	intgate.Offset( (DWORD) INTC );

	intgate.Descriptor( pidt->Descriptor( SYSINT_GENERALPROT ) );
	intgate.Selector( OSCode );
	intgate.Offset( (DWORD) INTD );

	intgate.Descriptor( pidt->Descriptor( SYSINT_PAGE ) );
	intgate.Selector( OSCode );
	intgate.Offset( (DWORD) INTE );

	intgate.Descriptor( pidt->Descriptor( 0xf ) );
	intgate.Selector( OSCode );
	intgate.Offset( (DWORD) INTF );

	intgate.Descriptor( pidt->Descriptor( SYSINT_MATHPROCERROR ) );
	intgate.Selector( OSCode );
	intgate.Offset( (DWORD) INT10 );

	intgate.Descriptor( pidt->Descriptor( SYSINT_UNALIGNMENT ) );
	intgate.Selector( OSCode );
	intgate.Offset( (DWORD) INT11 );

	intgate.Descriptor( pidt->Descriptor( 0x12 ) );
	intgate.Selector( OSCode );
	intgate.Offset( (DWORD) INT12 );

	intgate.Descriptor( pidt->Descriptor( 0x13 ) );
	intgate.Selector( OSCode );
	intgate.Offset( (DWORD) INT13 );

	intgate.Descriptor( pidt->Descriptor( 0x14 ) );
	intgate.Selector( OSCode );
	intgate.Offset( (DWORD) INT14 );

	intgate.Descriptor( pidt->Descriptor( 0x15 ) );
	intgate.Selector( OSCode );
	intgate.Offset( (DWORD) INT15 );

	intgate.Descriptor( pidt->Descriptor( 0x16 ) );
	intgate.Selector( OSCode );
	intgate.Offset( (DWORD) INT16 );

	intgate.Descriptor( pidt->Descriptor( 0x17 ) );
	intgate.Selector( OSCode );
	intgate.Offset( (DWORD) INT17 );

	intgate.Descriptor( pidt->Descriptor( 0x18 ) );
	intgate.Selector( OSCode );
	intgate.Offset( (DWORD) INT18 );

	intgate.Descriptor( pidt->Descriptor( 0x19 ) );
	intgate.Selector( OSCode );
	intgate.Offset( (DWORD) INT19 );

	intgate.Descriptor( pidt->Descriptor( 0x1A ) );
	intgate.Selector( OSCode );
	intgate.Offset( (DWORD) INT1A );

	intgate.Descriptor( pidt->Descriptor( 0x1B ) );
	intgate.Selector( OSCode );
	intgate.Offset( (DWORD) INT1B );

	intgate.Descriptor( pidt->Descriptor( 0x1C ) );
	intgate.Selector( OSCode );
	intgate.Offset( (DWORD) INT1C );

	intgate.Descriptor( pidt->Descriptor( 0x1D ) );
	intgate.Selector( OSCode );
	intgate.Offset( (DWORD) INT1D );

	intgate.Descriptor( pidt->Descriptor( 0x1E ) );
	intgate.Selector( OSCode );
	intgate.Offset( (DWORD) INT1E );

	intgate.Descriptor( pidt->Descriptor( 0x1F ) );
	intgate.Selector( OSCode );
	intgate.Offset( (DWORD) INT1F );

	intgate.Descriptor( pidt->Descriptor( 0x20 ) );
	intgate.Selector( OSCode );
	intgate.Offset( (DWORD) INT20 );

	intgate.Descriptor( pidt->Descriptor( 0x21 ) );
	intgate.Selector( OSCode );
	intgate.Offset( (DWORD) INT21 );

	intgate.Descriptor( pidt->Descriptor( 0x22 ) );
	intgate.Selector( OSCode );
	intgate.Offset( (DWORD) INT22 );

	intgate.Descriptor( pidt->Descriptor( 0x23 ) );
	intgate.Selector( OSCode );
	intgate.Offset( (DWORD) INT23 );

	intgate.Descriptor( pidt->Descriptor( 0x24 ) );
	intgate.Selector( OSCode );
	intgate.Offset( (DWORD) INT24 );

	intgate.Descriptor( pidt->Descriptor( 0x25 ) );
	intgate.Selector( OSCode );
	intgate.Offset( (DWORD) INT25 );

	intgate.Descriptor( pidt->Descriptor( 0x26 ) );
	intgate.Selector( OSCode );
	intgate.Offset( (DWORD) INT26 );

	intgate.Descriptor( pidt->Descriptor( 0x27 ) );
	intgate.Selector( OSCode );
	intgate.Offset( (DWORD) INT27 );

	intgate.Descriptor( pidt->Descriptor( 0x28 ) );
	intgate.Selector( OSCode );
	intgate.Offset( (DWORD) INT28 );

	intgate.Descriptor( pidt->Descriptor( 0x29 ) );
	intgate.Selector( OSCode );
	intgate.Offset( (DWORD) INT29 );

	intgate.Descriptor( pidt->Descriptor( 0x2A ) );
	intgate.Selector( OSCode );
	intgate.Offset( (DWORD) INT2A );

	intgate.Descriptor( pidt->Descriptor( 0x2B ) );
	intgate.Selector( OSCode );
	intgate.Offset( (DWORD) INT2B );

	intgate.Descriptor( pidt->Descriptor( 0x2C ) );
	intgate.Selector( OSCode );
	intgate.Offset( (DWORD) INT2C );

	intgate.Descriptor( pidt->Descriptor( 0x2D ) );
	intgate.Selector( OSCode );
	intgate.Offset( (DWORD) INT2D );

	intgate.Descriptor( pidt->Descriptor( 0x2E ) );
	intgate.Selector( OSCode );
	intgate.Offset( (DWORD) INT2E );

	intgate.Descriptor( pidt->Descriptor( 0x2F ) );
	intgate.Selector( OSCode );
	intgate.Offset( (DWORD) INT2F );

	CTrapGate trapgate;
	trapgate.Descriptor( pidt->Descriptor( SYSINT_SYSCALL ) );
	trapgate.Selector( OSCode );
	trapgate.DPL( 3 );
	trapgate.Offset( (DWORD) INT30 );
	}

// **************************************************************************
// Retorna el tamany de la memria fsica
DWORD CkeSystem::PhysicalMemory()
	{
	return dwphysicalmem;
	}

// **************************************************************************
// Retorna el flux que s'est executant
PCkeThread CkeSystem::Running()
	{
	return prun;
	}

// **************************************************************************
// Retorna el primer dels fluxos (de la llista de TOTS els fluxos)
PCkeThread CkeSystem::FirstThread()
	{
	DWORD flags = CLI();
	PCkeThread pt = pall; // Obtenim el valor amb exclusi mtua
	STI( flags );

	return pt;
	}

// **************************************************************************
// Retorna el primer dels fluxos (de la llista dels PREPARATS)
PCkeThread CkeSystem::Ready()
	{
	DWORD flags = CLI();
	PCkeThread pt = (PCkeThread) pready->Get(); // Obtenim el flux amb exclusi mtua
	STI( flags );

	return pt;
	}

// **************************************************************************
// Retorna l'objecte de la GDT utilitzada
PCGDT CkeSystem::GDT()
	{
	return pgdt;
	}

// **************************************************************************
// Selecciona un nou flux per a l'execuci
// Com a entrada ha de rebre:
// Run 	    	- Apuntador al flux
// Interrupt	- Indica si estem en temps d'interrupci
VOID CkeSystem::Running( PCkeThread pRun, BOOL bInterrupt )
	{
	prun = pRun;

	if( prun ) // Si volem executar un flux
		{
		PCTSS ctss = prun->TSS();
		tsssel = (WORD) ((ctss->GDT() - pgdt->Descriptor( 0 )) << 3); // Obtenim el selector
		prun->Status( STATUS_RUNNING );
		}
	else // Si volem executar la tasca 'Idle'
		tsssel = idletask;

	if( bInterrupt ) // Si estem en temps d'interrupci, fem EOI
		paal->EOI( TIMER_IRQ );

	JumpTSS(); // Saltem a la tasca nova
	}

// **************************************************************************
// Selecciona el primer flux de la llista de TOTS els fluxos
// Com a entrada ha de rebre:
// Thread	  	- Apuntador al primer dels fluxos
VOID CkeSystem::AddThread( PCkeThread pThread )
	{
	DWORD flags = CLI();

	pThread->NextInAll( pall ); // Per si no ho s
	pThread->PrevInAll( NULL ); // L'anterior s el primer actual

	if( pall )
		pall->PrevInAll( pThread );	// El segent s el nou

	pall = pThread;				// Seleccionem el nou primer, si no n'hi havia

	STI( flags );
	}

// **************************************************************************
// Introdueix un flux a la llista de fluxos PREPARATS
// Com a entrada ha de rebre:
// Thread	  	- Apuntador al flux
VOID CkeSystem::Ready( PCkeThread pThread )
	{
	DWORD flags = CLI();

	pThread->Status( STATUS_READY ); // El nou estat del flux s el de preparat
	pready->Add( pThread ); // Afegim el flux a la llista de preparats

	if( prun && prun->Priority() > pThread->Priority() ) // El flux en execuci t una prioritat menor
		{
		prun->Status( STATUS_READY ); // El nou estat del flux s el de preparat
		pready->Add( prun ); // L'afegim a la llista de preparats
		Kernel->Scheduler( FALSE ); // Passem a un flux ms prioritari
		}

	STI( flags );
	}

// **************************************************************************
// Retorna l'objecte que s'estava cercant
// Com a entrada ha de rebre:
// Name	    	- Nom de l'objecte que es busca
PCkeObject CkeSystem::FindObject( PSTR pName )
	{
	SETERRORCODE( OK );

	PSTR str = (PSTR) malloc( strlen( pName ) + 1 );
	strcpy( str, pName ); // Copiem la cadena perqu la modificarem durant la cerca
	PCkeObject temp = pobjdir->Analysis( str );
	free( str );

	return temp;
	}

// **************************************************************************
// Retorna l'objecte d'ajuda a la depuraci
PCkeDebug CkeSystem::Debug()
	{
	return &debugger;
	}

// **************************************************************************
// Retorna el tamany de les pgines
DWORD CkeSystem::PageSize()
	{
	return PAGE_SIZE;
	}

// **************************************************************************
// Retorna l'identificador del tipus de processador
DWORD CkeSystem::MachineType()
	{
	return dwmachinetype;
	}

// **************************************************************************
// Retorna el valor del comptador de 'ticks'
DWORD CkeSystem::TickTime()
	{
	return dwtimertick;
	}

// **************************************************************************
// Afegeix un cert temps al comptador de 'ticks'
// Com a entrada ha de rebre:
// Delta    	- Valor que s'ha d'afegir
VOID CkeSystem::AddTickTime( DWORD dwDelta )
	{
	dwtimertick += dwDelta;
	}

// **************************************************************************
// Retorna l'objecte que controla les pgines fsiques de memria
PCkePAT CkeSystem::PAT()
	{
	return ppat;
	}

// **************************************************************************
// Retorna l'objecte que controla el 'heap' del sistema
PCkeHeap CkeSystem::Heap()
	{
	return psysheap;
	}

// **************************************************************************
// Introdueix el codi d'error en el sistema (s'utilitza noms en la inicialitzaci)
VOID CkeSystem::Error( DWORD dwError )
	{
	dwerror = dwError;
	}

// **************************************************************************
// Retorna el codi d'error del sistema (s'utilitza noms en la inicialitzaci)
DWORD CkeSystem::Error()
	{
	return dwerror;
	}

// **************************************************************************
// Retorna l'apuntador a l'objecte AAL
PCaalAAL CkeSystem::AAL()
	{
	return paal;
	}

// **************************************************************************
// Presenta un missatge d'error i atura el sistema
VOID CkeSystem::Panic( PSTR sMessage )
	{
	syscon.Clear();
	syscon.GotoXY( 10, 2 );
	syscon.OutText( TEXT( "System Panic" ) );
	syscon.GotoXY( 5, 5 );
	syscon.OutText( sMessage );
	RegisterDump( syscon );
	syscon.GotoXY( 10, 23 );
	syscon.OutText( TEXT( "Sistema aturat" ) );

	CLI();
	while( 1 ) {}
	}

// **************************************************************************
// Retorna l'adrea de la RSI antiga i modifica la VIDT amb la nova
// Com a entrada ha de rebre:
// Interrupt	- Identifica la interrupci en la que es vol registrar
// Address  	- Indica l'adrea de memria de la RSI
DWORD CkeSystem::RegisterInterrupt( BYTE cInterrupt, DWORD dwAddress )
	{
	if( cInterrupt > MAX_VIRTUAL_INT )	// Hem de comprovar el lmit d'interrupcions
		{
		SETERRORCODE( VIT_BADINT );
		return 0L;
		}

	DWORD flags = CLI();

	DWORD old = dwvinttable[ cInterrupt ];	// Obtenim l'adrea anterior
	dwvinttable[ cInterrupt ] = dwAddress;	// Posem el nou apuntador

	STI( flags );

	SETERRORCODE( OK );

	return old;
	}

// **************************************************************************
// Selecciona la funci que s'ha de registrar en comptes de l'actual
// Com a entrada ha de rebre:
// Interrupt	- Identifica la interrupci de la que es vol desregistrar
// Address  	- Indica l'adrea de memria de la RSI antiga
void CkeSystem::UnregisterInterrupt( BYTE cInterrupt, DWORD dwAddress )
	{
// El codi d'aquest membre i de l'anterior s prcticament igual!! -BUG
	if( cInterrupt > MAX_VIRTUAL_INT )	// Hem de comprovar el lmit d'interrupcions
		SETERRORCODE( VIT_BADINT );
	else
		{
		DWORD flags = CLI();
		dwvinttable[ cInterrupt ] = dwAddress;	// Posem el nou apuntador
		STI( flags );

		SETERRORCODE( OK );
		}
	}

// **************************************************************************
// Retorna l'adrea de la RSI demanada
// Com a entrada ha de rebre:
// Interrupt	- Identifica la interrupci
DWORD CkeSystem::Interrupt( BYTE cInterrupt )
	{
	if( cInterrupt > MAX_VIRTUAL_INT )	// Hem de comprovar el lmit d'interrupcions
		return 0L;

	return dwvinttable[ cInterrupt ];	// Obtenim l'adrea
	}

// **************************************************************************
// Presenta per pantalla els registres del processador
// Com a entrada ha de rebre:
// cons     	- Objecte Console que utilitzem per a mostrar els registres
VOID CkeSystem::RegisterDump( CkeConsole &cons )
	{
	CHAR str[ 80 ];

	cons.GotoXY( 9, 10 );
	sprintf( str, TEXT( "EDI = %08X" ), int_regs.EDI );
	cons.OutText( str );
	cons.GotoXY( 9, 11 );
	sprintf( str, TEXT( "ESI = %08X" ), int_regs.ESI );
	cons.OutText( str );
	cons.GotoXY( 9, 12 );
	sprintf( str, TEXT( "EBP = %08X" ), int_regs.EBP );
	cons.OutText( str );
	cons.GotoXY( 9, 13 );
	sprintf( str, TEXT( "ESP = %08X" ), int_regs.ESP );
	cons.OutText( str );
	cons.GotoXY( 9, 14 );
	sprintf( str, TEXT( "CR2 = %08X" ), GetCR2() );
	cons.OutText( str );
	cons.GotoXY( 9, 15 );
	sprintf( str, TEXT( "CR3 = %08X" ), GetCR3() );
	cons.OutText( str );

	cons.GotoXY( 33, 10 );
	sprintf( str, TEXT( "EAX = %08X" ), int_regs.EAX );
	cons.OutText( str );
	cons.GotoXY( 33, 11 );
	sprintf( str, TEXT( "EBX = %08X" ), int_regs.EBX );
	cons.OutText( str );
	cons.GotoXY( 33, 12 );
	sprintf( str, TEXT( "ECX = %08X" ), int_regs.ECX );
	cons.OutText( str );
	cons.GotoXY( 33, 13 );
	sprintf( str, TEXT( "EDX = %08X" ), int_regs.EDX );
	cons.OutText( str );
	cons.GotoXY( 33, 14 );
	sprintf( str, TEXT( "EIP = %08X" ), int_regs.EIP );
	cons.OutText( str );
	cons.GotoXY( 30, 15 );
	sprintf( str, TEXT( "EFLAGS = %08X" ), int_regs.EFLAGS );
	cons.OutText( str );

	cons.GotoXY( 55, 10 );
	sprintf( str, TEXT( "CS = %04X" ), int_regs.CS );
	cons.OutText( str );
	cons.GotoXY( 55, 11 );
	sprintf( str, TEXT( "SS = %04X" ), int_regs.SS );
	cons.OutText( str );
	cons.GotoXY( 55, 12 );
	sprintf( str, TEXT( "DS = %04X" ), int_regs.DS );
	cons.OutText( str );
	cons.GotoXY( 55, 13 );
	sprintf( str, TEXT( "ES = %04X" ), int_regs.ES );
	cons.OutText( str );
	cons.GotoXY( 55, 14 );
	sprintf( str, TEXT( "FS = %04X" ), int_regs.FS );
	cons.OutText( str );
	cons.GotoXY( 55, 15 );
	sprintf( str, TEXT( "GS = %04X" ), int_regs.GS );
	cons.OutText( str );

	if( GetCR2() != int_regs.EIP ) // No intentem accedir a una adrea que ha fallat
		{
		cons.GotoXY( 0, 17 );
		cons.OutText( TEXT( "CS:EIP " ) );
		debugger.MemoryDump( (PBYTE) (int_regs.EIP & 0xfffffff0), 0x10 );
		cons.GotoXY( 0, 18 );
		cons.OutText( TEXT( "       " ) );
		debugger.MemoryDump( (PBYTE) (int_regs.EIP & 0xfffffff0) + 0x10, 0x10 );
		}

	if( GetCR2() != int_regs.ESP ) // No intentem accedir a una adrea que ha fallat
		{
		cons.GotoXY( 0, 20 );
		cons.OutText( TEXT( "SS:ESP " ) );
		debugger.MemoryDump( (PBYTE) (int_regs.ESP), 0x10 );
		}

	if( GetCR2() != int_regs.EBP ) // No intentem accedir a una adrea que ha fallat
		{
		cons.GotoXY( 0, 21 );
		cons.OutText( TEXT( "SS:EBP " ) );
		debugger.MemoryDump( (PBYTE) (int_regs.EBP), 0x10 );
		}
	}

// **************************************************************************
// Copia la part del directori de pgines com a tot el sistema
// Com a entrada ha de rebre:
// Dest     	- Posici del directori de pgines destinatari
VOID CkeSystem::CopyPageDirectory( PVOID pDest )
	{
// Copia noms la meitat superior del directori de pgines (i els 4 primers MB.)
	*((PDWORD) pDest) = *((PDWORD) PAGEDIR32_OFFSET);

	for( DWORD pos = PAGE_SIZE / (sizeof( DWORD ) * 2); pos < PAGE_SIZE / sizeof( DWORD ); pos ++ )
		*((PDWORD) pDest + pos) = *((PDWORD) PAGEDIR32_OFFSET + pos);
	}

// **************************************************************************
// Retorna l'adrea de la "consola" del sistema
PCkeConsole CkeSystem::Console()
	{
	return &syscon;
	}

// **************************************************************************
// Retorna l'adrea lgica corresponent a la taula de pgines passada com a parmetre
// Com a entrada ha de rebre:
// PhysAddress	- Adrea fsica de la taula de pgines
// PAT      	- Adrea de l'objecte PAT (per a utilitzar PAT16 o PAT32)
DWORD CkeSystem::MapPT( DWORD dwPhysAddress, PCkePAT pPAT )
	{
	// Comencem per 0xC0400000 (0xC0000000 s per a la taula de pgines)
	WORD index = (WORD) ((PAGE_REGION_ADDR >> (PAGE_BITS + 10)) + 1);
	BOOL found = FALSE; // Encara no hem trobat espai

	CTPage pagedir( (PTPage) PAGEDIR32_OFFSET );
	CPage pagetableentry;

	WORD subindex;

	while( index < 1020 && !found ) // seria 1024 si no hi hagus la PAT
		{
		PTPage PTE = pagedir.Page( index );
		pagetableentry.Page( PTE );
		if( pagetableentry.Present() )	// No es poden paginar les taules de pgina!! -BUG
			{
			subindex = 0; // Cerquem dins d'una taula de pgines
			CTPage pagetable( (PTPage) (PAGE_REGION_ADDR + ((DWORD) index << PAGE_BITS)) );

			while( subindex < 1024 && !found )
				{
				PTPage subPTE = pagetable.Page( subindex );
				pagetableentry.Page( subPTE );
				if( pagetableentry.Present() )	// No es poden paginar les taules de pgina!! -BUG
					subindex++;
				else
					found = TRUE; // Ja hem trobat un espai buit
				}
			}
		else
			{
			DWORD dwLogAddress = ((DWORD) index << (PAGE_BITS)) + PAGE_REGION_ADDR;

// Reservem la pgina que far de taula de pgines
			if( pPAT )
				pPAT->AllocPage( SYSTEM_PAGE, pagetableentry.Page(), dwLogAddress, NULL, NULL, TRUE );
			else
				ppat->AllocPage( SYSTEM_PAGE, pagetableentry.Page(), dwLogAddress, NULL, NULL, TRUE );

			pagetableentry.Readable( TRUE );

			subindex = 0; // Comencem a ocupar per la primera entrada
			found = TRUE;

			CTPage pagetable( (PTPage) (PAGE_REGION_ADDR + ((DWORD) index << PAGE_BITS)) );

			PTPage subPTE = pagetable.Page( 0 /*subindex*/ );
			pagetableentry.Page( subPTE );
			}

		if( !found )
			index++;
		}

	if( !found ) // No queda espai lliure per a la pgina
		{
		TRACE( TEXT( "MapPT - NOT FOUND!!!" ) );
		SETERRORCODE( PT_FULLZONE );
		return 0;
		}

	DWORD dwLogAddress = ((DWORD) subindex << (PAGE_BITS)) + ((DWORD) index << (PAGE_BITS + 10));

	pagetableentry.Writeable( TRUE ); // Preparem la pgina
	pagetableentry.User( FALSE );
	pagetableentry.COW( FALSE );
	pagetableentry.Readable( TRUE );
	pagetableentry.Executable( FALSE );
	pagetableentry.PageAddress( dwPhysAddress );
	pagetableentry.Present( TRUE );

	SETERRORCODE( OK );
	return dwLogAddress;
	}

// **************************************************************************
// Desmapeja una taula de pgines
// Com a entrada ha de rebre:
// LogAddress	- Adrea lgica de la taula de pgines
VOID CkeSystem::UnmapPT( DWORD dwLogAddress )
	{
	WORD index = (WORD) (dwLogAddress >> (PAGE_BITS + 10));

	CTPage pagedir( (PTPage) PAGEDIR32_OFFSET );
	PTPage PTE = pagedir.Page( index );
	CPage pagetableentry( PTE );
	if( pagetableentry.Present() )	// No es poden paginar les taules de pgina!! -BUG
		{
		WORD subindex = (WORD) ((dwLogAddress >> PAGE_BITS) & 0xffff);

		CTPage pagetable( pagetableentry.Page() );
		PTPage subPTE = pagetable.Page( subindex );
		pagetableentry.Page( subPTE );

		if( pagetableentry.Present() )
			{
			pagetableentry.Present( FALSE ); // Hem trobat la pgina, la desmapegem
			SETERRORCODE( OK );
			}
		else
			SETERRORCODE( PT_BADPAGETABLE );
		}
	else
		SETERRORCODE( PT_BADPAGETABLE );
	}

// **************************************************************************
// Retorna l'adrea de la llista de preparats
PCkeThreadList CkeSystem::ReadyList()
	{
	return pready;
	}

