/* **************************************************************************
*                                                                           *
*  TaskGate.CPP                                                             *
*                                                                           *
*  16-01-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classe per al control de les portes de tasca                             *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "kernel\taskgate.h"
#include "errors.h"
#include "kernel\system.h"

// **************************************************************************
// Prepara l'objecte
// Com a entrada ha de rebre:
// pDescr	- Apunta al descriptor de la TaskGate
CTaskGate::CTaskGate( PTDescriptor pDescr ) : CGate( pDescr )
	{
	id	= CID_TaskGate;
	}

// **************************************************************************
// Destrueix l'objecte
CTaskGate::~CTaskGate()
	{
	}

// **************************************************************************
// Indica si la classe de l'objecte s o no la que es passa com a parmetre
// Com a entrada ha de rebre:
// Cuid     	- Identificador de la classe
BOOL CTaskGate::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_TaskGate )
		return TRUE;
	else
		return CGate::ClassCheck( Cuid );
	}

// **************************************************************************
// Retorna el nombre de dobles paraules que pren com a parmetres
BYTE CTaskGate::Params()
	{
	if( binitialized )
		SETERRORCODE( GATE_NOTPERMITTED );
	else
		SETERRORCODE( GATE_UNINITIALIZED );

	return 0;
	}

// **************************************************************************
// Prepara l'objecte per a utilitzar p dobles paraules com a parmetres
// Com a entrada ha de rebre:
// p	- Nombre de dobles paraules que formen els parmetres
VOID CTaskGate::Params( BYTE )
	{
	if( binitialized )
		SETERRORCODE( GATE_NOTPERMITTED );
	else
		SETERRORCODE( GATE_UNINITIALIZED );
	}

// **************************************************************************
// Prepara el descriptor segons les necessitats de les portes de tasca
// Com a entrada ha de rebre:
// Desc	- Apuntador cap al descriptor
VOID CTaskGate::Descriptor( PTDescriptor pDesc )
	{
	CGate::Descriptor( pDesc );

	SetProcessor();
	SetTaskgate();
	DPL( 0 );
	Present( TRUE );
	}

