/* **************************************************************************
*                                                                           *
*  TPags.CPP                                                                *
*                                                                           *
*  21-01-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classe per a la utilitzaci de les taules de pgina                      *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "kernel\tpags.h"
#include "errors.h"
#include "string.h"
#include "kernel\system.h"

#define MAX_INDEX		1024	/* 4096 bytes / 4 bytes per entrada */

// **************************************************************************
// Constructor de la classe
// Com a entrada ha de rebre:
// Pag      	- Adrea de la taula de pagines
CTPage::CTPage( PTPage Pag ) : CkeType( CID_PageTable )
	{
	TPage( Pag );
	}

// **************************************************************************
// Destructor de la classe
CTPage::~CTPage()
	{
	}

// **************************************************************************
// Indica si la classe de l'objecte es o no la que es passa com a parametre
// Com a entrada ha de rebre:
// Cuid     	- Identificador de la classe
BOOL CTPage::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_PageTable )
		return TRUE;
	else
		return CkeType::ClassCheck( Cuid );
	}

// **************************************************************************
// Selecciona una nova adrea per a la taula de pagines
// Com a entrada ha de rebre:
// Pag      	- Apuntador a la nova adrea
VOID CTPage::TPage( PTPage Pag )
	{
	ppag				= Pag;
	binitialized	= (ppag != NULL ? TRUE : FALSE);
	}

// **************************************************************************
// Retorna l'adrea de la taula de pagines
PTPage CTPage::TPage()
	{
	if( binitialized )
		return ppag;

	return NULL;
	}

// **************************************************************************
// Inicialitza la taula de pagines amb uns valors per defecte
VOID CTPage::Clear()
	{
	if( binitialized )
		{
		CPage page;

		for( int index = 0; index < MAX_INDEX; index++ )
			{
			page.Page( &ppag[ index ] );
			page.Clear();
			}
		}
	}

// **************************************************************************
// Retorna l'entrada de la taula seleccionada
// Com a entrada ha de rebre:
// index    	- Index dins la taula de pagines
PTPage CTPage::Page( WORD index )
	{
	if( binitialized )
		{
		if( index <= MAX_INDEX )
			{
#ifdef _DEBUG
			if( DebugLevel > 97 )
				{
				CHAR str[ 80 ];
				sprintf( str, TEXT( "ppag: %08x, index: %08x" ), (DWORD) ppag, index );
				TRACE( str );
				}
#endif
			return &ppag[ index ];
			}

		return NULL;
		}

	return NULL;
	}

