/* **************************************************************************
*                                                                           *
*  TSS.CPP                                                                  *
*                                                                           *
*  13-07-96                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classe per a la utilitzaci dels TSSs                                    *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "kernel\tss.h"
#include "errors.h"
#include "kernel\system.h"

// **************************************************************************
// Constructor de la classe
// Com a entrada ha de rebre:
// Gdt      	- Apuntador al descriptor de tipus TSS dins la GDT
CTSS::CTSS( PTDescriptor Gdt ) : CkeType( CID_TSS )
	{
	GDT( Gdt );
	}

// **************************************************************************
// Destructor de la classe
CTSS::~CTSS()
	{
	TRACE( TEXT( "Destrunt TSS!" ) );

//	pgdt->SetPresent( FALSE );
// Alliberar memria? -BUG
	}

// **************************************************************************
// Indica si la classe de l'objecte s o no la que es passa com a parmetre
// Com a entrada ha de rebre:
// Cuid     	- Identificador de la classe
BOOL CTSS::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_TSS )
		return TRUE;
	else
		return CkeType::ClassCheck( Cuid );
	}

// **************************************************************************
// Selecciona un nou descriptor de la GDT
// Com a entrada ha de rebre:
// Gdt      	- Apuntador al nou descriptor de tipus TSS
VOID CTSS::GDT( PTDescriptor Gdt )
	{
	pgdt = Gdt;

	if( pgdt )
		{
// Inicialitzar desc amb el format requerit
		binitialized 		= TRUE;
		PCDescriptor desc	= new CDescriptor( Gdt );
		ptss					= (PTTSS) desc->Base();
		delete desc;
		}
	else
		{
		binitialized	= FALSE;
		ptss				= NULL;
		}
	}

// **************************************************************************
// Retorna l'adrea del descriptor de la TSS
PTDescriptor CTSS::GDT()
	{
	if( binitialized )
		SETERRORCODE( OK );
	else
		SETERRORCODE( TSS_UNINITIALIZED );

	return pgdt;	// Si hi ha error, el valor s indeterminat
	}

// **************************************************************************
// Selecciona aquesta tasca per al processador
VOID CTSS::SetHard()
	{
	if( binitialized )
		{
		SETERRORCODE( OK );
// LTR this -BUG
		}
	else
		SETERRORCODE( TSS_UNINITIALIZED );
	}

// **************************************************************************
// Obt la tasca que s'esta executant actualment
VOID CTSS::GetHard()
	{
	if( binitialized )
		{
// Obtenir TR -BUG
		}
	else
		{
// Obtenir GDT i TR -BUG
		}
	}

// **************************************************************************
// Esborra el contingut del TSS
VOID CTSS::Clear()
	{
	PDWORD tss = (PDWORD) ptss;

	for( DWORD pos = 0; pos < sizeof( TTSS ) / sizeof( DWORD ); pos++ )
		tss[ pos ] = 0;
	}

// **************************************************************************
// Retorna l'indicador de tasca ocupada
BOOL CTSS::Busy()
	{
	if( binitialized )
		{
		SETERRORCODE( OK );
		CDescriptor *desc = new CDescriptor( pgdt );

		if( desc->FreeTSS386() ) // Est lliure?
			{
			delete desc;
			return FALSE;
			}

		delete desc;
		return TRUE;
		}
	else
		SETERRORCODE( TSS_UNINITIALIZED );

	return FALSE;
	}

// **************************************************************************
// Modifica l'indicador de tasca ocupada
// Com a entrada ha de rebre:
// Busy     	- Indica que la tasca esta ocupada (1) o no (0)
VOID CTSS::Set( BOOL Busy )
	{
	if( binitialized )
		{
		SETERRORCODE( OK );
		CDescriptor *desc = new CDescriptor( pgdt );

		if( Busy )
			desc->SetBusyTSS386(); // Ocupada
		else
			desc->SetFreeTSS386(); // Lliure

		delete desc;
		}
	else
		SETERRORCODE( TSS_UNINITIALIZED );
	}

// **************************************************************************
// Aquestes funcions retornen algun dels parmetres del TSS

// -- Obt el selector de la tasca interrompuda per l'actual
WORD CTSS::BackLink()
	{
	if( binitialized )
		{
		SETERRORCODE( OK );

		return ptss->BackLink;
		}
	else
		SETERRORCODE( TSS_UNINITIALIZED );

	return 0;
	}

// -- Obt la pila del nivell seleccionat
VOID CTSS::GetStack( BYTE level, WORD& ss, DWORD& esp )
	{
	if( binitialized )
		{
		SETERRORCODE( OK );

		switch( level )
			{
			case 0:
				ss		= ptss->SS0;
				esp	= ptss->ESP0;
				break;
			case 1:
				ss		= ptss->SS1;
				esp	= ptss->ESP1;
				break;
			case 2:
				ss		= ptss->SS2;
				esp	= ptss->ESP2;
				break;
			default:
				SETERRORCODE( TSS_STACKLEVEL );
			}
		}
	else
		SETERRORCODE( TSS_UNINITIALIZED );
	}

// -- Obt l'adrea del directori de pgines
DWORD	CTSS::PDBR()
	{
	if( binitialized )
		{
		SETERRORCODE( OK );

		return ptss->PDBR;
		}
	else
		SETERRORCODE( TSS_UNINITIALIZED );

	return 0L;
	}

// -- Obt l'adrea de la propera instrucci a executar-se en aquesta tasca
VOID CTSS::GetCSEIP( WORD &cs, DWORD &eip )
	{
	if( binitialized )
		{
		SETERRORCODE( OK );

		cs		= ptss->CS;
		eip	= ptss->EIP;
		}
	else
		SETERRORCODE( TSS_UNINITIALIZED );
	}

// -- Obt els 'Flags'
DWORD CTSS::EFLAGS()
	{
	if( binitialized )
		{
		SETERRORCODE( OK );

		return ptss->EFLAGS;
		}
	else
		SETERRORCODE( TSS_UNINITIALIZED );

	return 0L;
	}

// -- Obt el registre EAX
DWORD CTSS::EAX()
	{
	if( binitialized )
		{
		SETERRORCODE( OK );

		return ptss->EAX;
		}
	else
		SETERRORCODE( TSS_UNINITIALIZED );

	return 0L;
	}

// -- Obt el registre EBX
DWORD CTSS::EBX()
	{
	if( binitialized )
		{
		SETERRORCODE( OK );

		return ptss->EBX;
		}
	else
		SETERRORCODE( TSS_UNINITIALIZED );

	return 0L;
	}

// -- Obt el registre ECX
DWORD CTSS::ECX()
	{
	if( binitialized )
		{
		SETERRORCODE( OK );

		return ptss->ECX;
		}
	else
		SETERRORCODE( TSS_UNINITIALIZED );

	return 0L;
	}

// -- Obt el registre EDX
DWORD CTSS::EDX()
	{
	if( binitialized )
		{
		SETERRORCODE( OK );

		return ptss->EDX;
		}
	else
		SETERRORCODE( TSS_UNINITIALIZED );

	return 0L;
	}

// -- Obt el registre ESP
DWORD CTSS::ESP()
	{
	if( binitialized )
		{
		SETERRORCODE( OK );

		return ptss->ESP;
		}
	else
		SETERRORCODE( TSS_UNINITIALIZED );

	return 0L;
	}

// -- Obt el registre EBP
DWORD CTSS::EBP()
	{
	if( binitialized )
		{
		SETERRORCODE( OK );

		return ptss->EBP;
		}
	else
		SETERRORCODE( TSS_UNINITIALIZED );

	return 0L;
	}

// -- Obt el registre EDI
DWORD CTSS::EDI()
	{
	if( binitialized )
		{
		SETERRORCODE( OK );

		return ptss->EDI;
		}
	else
		SETERRORCODE( TSS_UNINITIALIZED );

	return 0L;
	}

// -- Obt el registre ESI
DWORD CTSS::ESI()
	{
	if( binitialized )
		{
		SETERRORCODE( OK );

		return ptss->ESI;
		}
	else
		SETERRORCODE( TSS_UNINITIALIZED );

	return 0L;
	}

// -- Obt el registre ES
WORD CTSS::ES()
	{
	if( binitialized )
		{
		SETERRORCODE( OK );

		return ptss->ES;
		}
	else
		SETERRORCODE( TSS_UNINITIALIZED );

	return 0;
	}

// -- Obt el registre SS
WORD CTSS::SS()
	{
	if( binitialized )
		{
		SETERRORCODE( OK );

		return ptss->SS;
		}
	else
		SETERRORCODE( TSS_UNINITIALIZED );

	return 0;
	}

// -- Obt el registre DS
WORD CTSS::DS()
	{
	if( binitialized )
		{
		SETERRORCODE( OK );

		return ptss->DS;
		}
	else
		SETERRORCODE( TSS_UNINITIALIZED );

	return 0;
	}

// -- Obt el registre FS
WORD CTSS::FS()
	{
	if( binitialized )
		{
		SETERRORCODE( OK );

		return ptss->FS;
		}
	else
		SETERRORCODE( TSS_UNINITIALIZED );

	return 0;
	}

// -- Obt el registre GS
WORD CTSS::GS()
	{
	if( binitialized )
		{
		(System->Running())->ErrorCode( OK );

		return ptss->GS;
		}
	else
		SETERRORCODE( TSS_UNINITIALIZED );

	return 0;
	}

// -- Obt l'LDT de la tasca
WORD CTSS::LDT()
	{
	if( binitialized )
		{
		SETERRORCODE( OK );

		return ptss->LDT;
		}
	else
		SETERRORCODE( TSS_UNINITIALIZED );

	return 0;
	}

// -- Obt l'indicador de 'Trap'
BOOL CTSS::T()
	{
	if( binitialized )
		{
		SETERRORCODE( OK );

		return ptss->Flags.Bits.T;
		}
	else
		SETERRORCODE( TSS_UNINITIALIZED );

	return FALSE;
	}

// -- Obt l'adrea de l'inici del mapa d'entrada/sortida
WORD CTSS::IOMap()
	{
	if( binitialized )
		{
		SETERRORCODE( OK );

		return ptss->IOMap;
		}
	else
		SETERRORCODE( TSS_UNINITIALIZED );

	return 0;
	}

// **************************************************************************
// Aquestes funcions modifiquen els parmetres del TSS

// -- Selecciona una nova tasca interrompuda
VOID CTSS::BackLink( WORD bl )
	{
	if( binitialized )
		{
		SETERRORCODE( OK );

		ptss->BackLink = bl;
		}
	else
		SETERRORCODE( TSS_UNINITIALIZED );
	}

// -- Selecciona una nova pila per al nivell especificat
VOID CTSS::SetStack( BYTE level, WORD ss, DWORD esp )
	{
	if( binitialized )
		{
		SETERRORCODE( OK );

		switch( level )
			{
			case 0:
				ptss->SS0	= ss;
				ptss->ESP0	= esp;
				break;
			case 1:
				ptss->SS1	= ss;
				ptss->ESP1	= esp;
				break;
			case 2:
				ptss->SS2	= ss;
				ptss->ESP2	= esp;
				break;
			default:
				SETERRORCODE( TSS_STACKLEVEL );
			}
		}
	else
		SETERRORCODE( TSS_UNINITIALIZED );
	}

// -- Selecciona un nou directori de pgines
VOID CTSS::PDBR( DWORD pdbr )
	{
	if( binitialized )
		{
		SETERRORCODE( OK );

		ptss->PDBR = pdbr;
		}
	else
		SETERRORCODE( TSS_UNINITIALIZED );
	}

// -- Selecciona una nova adrea per a la propera instrucci a executar
VOID CTSS::SetCSEIP( WORD cs, DWORD eip )
	{
	if( binitialized )
		{
		SETERRORCODE( OK );

		ptss->CS		= cs;
		ptss->EIP	= eip;
		}
	else
		SETERRORCODE( TSS_UNINITIALIZED );
	}

// -- Selecciona una nova pila per a la tasca
VOID CTSS::SetSSESP( WORD ss, DWORD esp )
	{
	if( binitialized )
		{
		SETERRORCODE( OK );

		ptss->SS		= ss;
		ptss->ESP	= esp;
		}
	else
		SETERRORCODE( TSS_UNINITIALIZED );
	}

// -- Selecciona un nous 'Flags'
VOID CTSS::EFLAGS( DWORD eflags )
	{
	if( binitialized )
		{
		SETERRORCODE( OK );

		ptss->EFLAGS	= eflags;
		}
	else
		SETERRORCODE( TSS_UNINITIALIZED );
	}

// -- Selecciona un nou valor per a EAX
VOID CTSS::EAX( DWORD eax )
	{
	if( binitialized )
		{
		SETERRORCODE( OK );

		ptss->EAX = eax;
		}
	else
		SETERRORCODE( TSS_UNINITIALIZED );
	}

// -- Selecciona un nou valor per a EBX
VOID CTSS::EBX( DWORD ebx )
	{
	if( binitialized )
		{
		SETERRORCODE( OK );

		ptss->EBX = ebx;
		}
	else
		SETERRORCODE( TSS_UNINITIALIZED );
	}

// -- Selecciona un nou valor per a ECX
VOID CTSS::ECX( DWORD ecx )
	{
	if( binitialized )
		{
		SETERRORCODE( OK );

		ptss->ECX = ecx;
		}
	else
		SETERRORCODE( TSS_UNINITIALIZED );
	}

// -- Selecciona un nou valor per a EDX
VOID CTSS::EDX( DWORD edx )
	{
	if( binitialized )
		{
		SETERRORCODE( OK );

		ptss->EDX = edx;
		}
	else
		SETERRORCODE( TSS_UNINITIALIZED );
	}

// -- Selecciona un nou valor per a ESP
VOID CTSS::ESP( DWORD esp )
	{
	if( binitialized )
		{
		SETERRORCODE( OK );

		ptss->ESP = esp;
		}
	else
		SETERRORCODE( TSS_UNINITIALIZED );
	}

// -- Selecciona un nou valor per a EBP
VOID CTSS::EBP( DWORD ebp )
	{
	if( binitialized )
		{
		SETERRORCODE( OK );

		ptss->EBP = ebp;
		}
	else
		SETERRORCODE( TSS_UNINITIALIZED );
	}

// -- Selecciona un nou valor per a EDI
VOID CTSS::EDI( DWORD edi )
	{
	if( binitialized )
		{
		SETERRORCODE( OK );

		ptss->EDI = edi;
		}
	else
		SETERRORCODE( TSS_UNINITIALIZED );
	}

// -- Selecciona un nou valor per a ESI
VOID CTSS::ESI( DWORD esi )
	{
	if( binitialized )
		{
		SETERRORCODE( OK );

		ptss->ESI = esi;
		}
	else
		SETERRORCODE( TSS_UNINITIALIZED );
	}

// -- Selecciona un nou valor per a ES
VOID CTSS::ES( WORD es )
	{
	if( binitialized )
		{
		SETERRORCODE( OK );

		ptss->ES = es;
		}
	else
		SETERRORCODE( TSS_UNINITIALIZED );
	}

// -- Selecciona un nou valor per a SS
VOID CTSS::SS( WORD ss )
	{
	if( binitialized )
		{
		SETERRORCODE( OK );

		ptss->SS = ss;
		}
	else
		SETERRORCODE( TSS_UNINITIALIZED );
	}

// -- Selecciona un nou valor per a DS
VOID CTSS::DS( WORD ds )
	{
	if( binitialized )
		{
		SETERRORCODE( OK );

		ptss->DS = ds;
		}
	else
		SETERRORCODE( TSS_UNINITIALIZED );
	}

// -- Selecciona un nou valor per a FS
VOID CTSS::FS( WORD fs )
	{
	if( binitialized )
		{
		SETERRORCODE( OK );

		ptss->FS = fs;
		}
	else
		SETERRORCODE( TSS_UNINITIALIZED );
	}

// -- Selecciona un nou valor per a GS
VOID CTSS::GS( WORD gs )
	{
	if( binitialized )
		{
		SETERRORCODE( OK );

		ptss->GS = gs;
		}
	else
		SETERRORCODE( TSS_UNINITIALIZED );
	}

// -- Selecciona una nova LDT
VOID CTSS::LDT( WORD ldt )
	{
	if( binitialized )
		{
		SETERRORCODE( OK );

		ptss->LDT = ldt;
		}
	else
		SETERRORCODE( TSS_UNINITIALIZED );
	}

// -- Selecciona un nou valor per a l'indicador de 'Trap'
VOID CTSS::T( BOOL t )
	{
	if( binitialized )
		{
		SETERRORCODE( OK );

		ptss->Flags.Bits.T = t;
		}
	else
		SETERRORCODE( TSS_UNINITIALIZED );
	}

// -- Selecciona una nova adrea per al mapa d'E/S
VOID CTSS::IOMap( WORD iomap )
	{
	if( binitialized )
		{
		SETERRORCODE( OK );

		ptss->IOMap = iomap;
		}
	else
		SETERRORCODE( TSS_UNINITIALIZED );
	}

