/* **************************************************************************
*                                                                           *
*  VAD.CPP                                                                  *
*                                                                           *
*  11-01-97                                                    BUILD:0002   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classe que controla les Virtual Address Descriptor                       *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "kernel\vad.h"
#include "errors.h"
#include "kernel\system.h"
#include "kernel\asm.h"

// **************************************************************************
// Constructor de la classe
// Com a entrada ha de rebre:
// pVAD     	- Apuntador al primer dels VADs (pot ser NULL)
// Size     	- Tamany de la regio
CkeVAD::CkeVAD( PVOID pAddress, PCkeProcess pProcess, PCkeRegion pRegion, BYTE cProt, PCkeVAD pPrev, PCkeVAD pNext ) : CkeDblListItem( pPrev, pNext )
	{
	id = CID_VAD;

	DWORD flags = CLI();

	VirtualAddress( pAddress );
	Process( pProcess );
	Region( pRegion );
	Protection( cProt );

	STI( flags );
	}

// **************************************************************************
// Destructor de la classe
CkeVAD::~CkeVAD()
	{
	}

// **************************************************************************
// Indica si la classe de l'objecte s o no la que es passa com a parmetre
// Com a entrada ha de rebre:
// Cuid     	- Identificador de la classe
BOOL CkeVAD::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_VAD )
		return TRUE;
	else
		return CkeDblListItem::ClassCheck( Cuid );
	}

// **************************************************************************
// Constructor de la classe
// Com a entrada ha de rebre:
// pVAD     	- Apuntador al primer dels VADs (pot ser NULL)
// Size     	- Tamany de la regio
PVOID CkeVAD::VirtualAddress()
	{
	return pvirtualaddress;
	}

// **************************************************************************
// Constructor de la classe
// Com a entrada ha de rebre:
// pVAD     	- Apuntador al primer dels VADs (pot ser NULL)
// Size     	- Tamany de la regio
PCkeProcess CkeVAD::Process()
	{
	return pproc;
	}

// **************************************************************************
// Constructor de la classe
// Com a entrada ha de rebre:
// pVAD     	- Apuntador al primer dels VADs (pot ser NULL)
// Size     	- Tamany de la regio
PCkeRegion CkeVAD::Region()
	{
	return pregion;
	}

// **************************************************************************
// Constructor de la classe
// Com a entrada ha de rebre:
// pVAD     	- Apuntador al primer dels VADs (pot ser NULL)
// Size     	- Tamany de la regio
BYTE CkeVAD::Protection()
	{
	return cprivateprotection;
	}

// **************************************************************************
// Constructor de la classe
// Com a entrada ha de rebre:
// pVAD     	- Apuntador al primer dels VADs (pot ser NULL)
// Size     	- Tamany de la regio
VOID CkeVAD::VirtualAddress( PVOID pAddress )
	{
	DWORD flags = CLI();
	pvirtualaddress = pAddress;
	STI( flags );
	}

// **************************************************************************
// Constructor de la classe
// Com a entrada ha de rebre:
// pVAD     	- Apuntador al primer dels VADs (pot ser NULL)
// Size     	- Tamany de la regio
VOID CkeVAD::Process( PCkeProcess pProcess )
	{
	DWORD flags = CLI();
	pproc = pProcess;
	STI( flags );
	}

// **************************************************************************
// Constructor de la classe
// Com a entrada ha de rebre:
// pVAD     	- Apuntador al primer dels VADs (pot ser NULL)
// Size     	- Tamany de la regio
VOID CkeVAD::Region( PCkeRegion pRegion )
	{
	DWORD flags = CLI();
	pregion = pRegion;
	STI( flags );
	}

// **************************************************************************
// Constructor de la classe
// Com a entrada ha de rebre:
// pVAD     	- Apuntador al primer dels VADs (pot ser NULL)
// Size     	- Tamany de la regio
VOID CkeVAD::Protection( BYTE cProt )
	{
	DWORD flags = CLI();
	cprivateprotection = cProt;
	STI( flags );
	}

