/* **************************************************************************
*                                                                           *
*  AcToken.CPP                                                              *
*                                                                           *
*  03-02-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classe genrica de seguretat per a usuaris i grups                       *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "sys\private\actoken.h"
#include "string.h"

// **************************************************************************
// Constructor de la classe
// Com a entrada ha de rebre:
// Name    			- Nom de l'usuari o grup
// LongName			- Descripci de l'usuari o grup
// Privileges		- Privilegis actuals
// NotPrivileges	- Privilegis negats
CAccessToken::CAccessToken( PSTR sName, PSTR sLongName, DWORD dwPrivileges, DWORD dwNotPrivileges ) : CkeType( CID_AccessToken )
	{
	LongName( sLongName );
	Name( sName );
	dwprivileges 		= dwPrivileges;
	dwnotprivileges 	= dwNotPrivileges;
	}

// **************************************************************************
// Destructor de la classe
CAccessToken::~CAccessToken()
	{
	}

BOOL CAccessToken::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_AccessToken )
		return TRUE;
	else
		return CkeType::ClassCheck( Cuid );
	}

// **************************************************************************
// Retorna la descripci de l'usuari o grup
PSTR CAccessToken::LongName()
	{
	return slongname;
	}

// **************************************************************************
// Retorna el nom de l'usuari o grup
PSTR CAccessToken::Name()
	{
	return scallname;
	}

// **************************************************************************
// Aquestes funcions consulten cada un dels privilegis de l'objecte
// **************************************************************************

BOOL CAccessToken::None()
	{
	return FALSE;
	}

BOOL CAccessToken::LockMemory()
	{
	return TRUE;
	}

BOOL CAccessToken::IncreaseQuota()
	{
	return TRUE;
	}

BOOL CAccessToken::LoadDriver()
	{
	return TRUE;
	}

BOOL CAccessToken::SystemTime()
	{
	return TRUE;
	}

BOOL CAccessToken::IncreaseBasePriority()
	{
	return TRUE;
	}

BOOL CAccessToken::CreatePageFile()
	{
	return TRUE;
	}

BOOL CAccessToken::Backup()
	{
	return TRUE;
	}

BOOL CAccessToken::Restore()
	{
	return TRUE;
	}

BOOL CAccessToken::Shutdown()
	{
	return TRUE;
	}

BOOL CAccessToken::Debug()
	{
	return TRUE;
	}

BOOL CAccessToken::Audit()
	{
	return TRUE;
	}

// **************************************************************************
// Canvia la descripci de l'usuari o grup
// Com a entrada ha de rebre:
// Name    		- Nova descripci
VOID CAccessToken::LongName( PSTR Name )
	{
	sprintf( slongname, TEXT( "%s" ), Name );
	}

// **************************************************************************
// Canvia el nom de l'usuari o grup
// Com a entrada ha de rebre:
// Name    		- Nou nom
VOID CAccessToken::Name( PSTR Name )
	{
	sprintf( scallname, TEXT( "%s" ), Name );
	}

// **************************************************************************
// Aquestes funcions modifiquen cada un dels privilegis de l'objecte
// Com a entrada ha de rebre:
// Value   		- Nou valor per al privilegi
// **************************************************************************

VOID CAccessToken::None( BOOL )
	{
	}

VOID CAccessToken::LockMemory( BOOL )
	{
	}

VOID CAccessToken::IncreaseQuota( BOOL )
	{
	}

VOID CAccessToken::LoadDriver( BOOL )
	{
	}

VOID CAccessToken::SystemTime( BOOL )
	{
	}

VOID CAccessToken::IncreaseBasePriority( BOOL )
	{
	}

VOID CAccessToken::CreatePageFile( BOOL )
	{
	}

VOID CAccessToken::Backup( BOOL )
	{
	}

VOID CAccessToken::Restore( BOOL )
	{
	}

VOID CAccessToken::Shutdown( BOOL )
	{
	}

VOID CAccessToken::Debug( BOOL )
	{
	}

VOID CAccessToken::Audit( BOOL )
	{
	}

