/* **************************************************************************
*                                                                           *
*  Callback.CPP                                                             *
*                                                                           *
*  03-02-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classe per a la gesti de les funcions de 'Callback'                     *
*                                                                           *
************************************************************************** */

#include "sys\private\callback.h"
#include "kernel\callback.h"
#include "kernel\system.h"

// **************************************************************************
// Constructor de la classe
// Com a entrada ha de rebre:
// Mailbox 			- Bstia on s'envia el missatge d'atenci
// Object  			- Objecte pare de la 'callback'
// Name    			- Nom de la 'callback'
CCallback::CCallback( PCMailBox pMailbox, PCObject pObject, PSTR sName ) : CResource()
	{
	id = CID_Callback;

	if( pMailbox )
		CreateCallback( pMailbox, pObject, sName );
	}

// **************************************************************************
// Destructor de la classe
CCallback::~CCallback()
	{
	delete pobject;
	}

BOOL CCallback::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_Callback )
		return TRUE;
	else
		return CResource::ClassCheck( Cuid );
	}

// **************************************************************************
// Crea una 'callback'
// Com a entrada ha de rebre:
// Mailbox 			- Bstia on s'envia el missatge d'atenci
// Object  			- Objecte pare de la 'callback'
// Name    			- Nom de la 'callback'
VOID CCallback::CreateCallback( PCMailBox pMailbox, PCObject pObject, PSTR sName )
	{
	pobject = new CkeCallback( (PCkeMailBox) pMailbox->GetInternalPointer(), (PCkeObject) pObject->GetInternalPointer(), sName );
	}

