/* **************************************************************************
*                                                                           *
*  EXE.CPP                                                                  *
*                                                                           *
*  04-03-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classe per a l'execuci dels programes Akula                             *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#define _MAX_PATH		250			/* ????????????????!!!!!!!!!!! -BUG */

#include "sys\private\exe.h"
#include "string.h"
#include "errors.h"
#include "\eros\i386\16bit\dosload\version.h"
#include "kernel\pcb.h"
#include "kernel\system.h"

// **************************************************************************
// Constructor de la classe
// Com a entrada ha de rebre:
// File    		- Fitxer executable
CExecutableFile::CExecutableFile( PCdrvUserFile pFile ) : CkeType( CID_ExecutableFile )
	{
// Inicialitzem les variables de l'objecte
	bcertified = FALSE;
	pfile = pFile;

// Comprovem que sigui un executable correcte
	CertifyExecutable();
	dwfirstsection = pfile->Seek( 0, SEEK_CUR );

	if( (System->Running())->ErrorCode() == OK )
		{
		if( Machine() != IMAGE_FILE_MACHINE_I386 ) // Per a Intel386 i compatibles
			(System->Running())->ErrorCode( LDR_BAD_MACHINE );
		}

	if( !(System->Running())->ErrorCode() )
		{
		DWORD os = OperatingSystemVersion();
		// Comprovem la versi del sistema operatiu
		if( HIWORD( os ) > MAJOR_VERSION || (LOWORD( os ) > MINOR_VERSION && HIWORD( os ) == MAJOR_VERSION))
			(System->Running())->ErrorCode( LDR_BAD_VERSION );
		}

	if( !(System->Running())->ErrorCode() )
		{
		// Comprovem el subsistema
		switch( Subsystem() )
			{
			case IMAGE_SUBSYSTEM_NATIVE:
			case IMAGE_SUBSYSTEM_WINDOWS_GUI:
			case IMAGE_SUBSYSTEM_WINDOWS_CUI:
				(System->Running())->ErrorCode( OK );
				break;

			default:
				(System->Running())->ErrorCode( LDR_BAD_SUBSYSTEM );
			}
		}
	}

// **************************************************************************
// Destructor de la classe
CExecutableFile::~CExecutableFile()
	{
	bcertified = FALSE;
	}

// **************************************************************************
// Comprova que el fitxer executable comenci amb l'estructura del DOS MZ
VOID CExecutableFile::Check_MZ_HDR()
	{
// Llegim la capcelera del fitxer que ha de tenir l'estructura IMAGE_DOS_HEADER
	pfile->Read( &dos_hdr, sizeof( IMAGE_DOS_HEADER ) );
// Comprovem que la marca sigui correcta
	if( dos_hdr.e_magic == IMAGE_DOS_SIGNATURE )
		(System->Running())->ErrorCode( OK );								// Si ho s, OK
	else
		(System->Running())->ErrorCode( LDR_BAD_MZ_HDR );				// Si no, hi ha error en capcelera MZ
	}

// **************************************************************************
// Comprova que el fitxer executable contigui en el lloc correcte l'estructura NT/Akula PE
VOID CExecutableFile::Check_PE_HDR()
	{
// Cerquem el punt d'inici de l'estructura IMAGE_NT_HEADERS
	pfile->Seek( dos_hdr.e_lfanew, SEEK_SET );
// Llegim l'estructura IMAGE_NT_HEADERS del fitxer
	pfile->Read( &akula_hdr, sizeof( IMAGE_NT_HEADERS ) );
// La signatura de l'estructura s PE\0\0
	if( akula_hdr.Signature == IMAGE_EROS_SIGNATURE && akula_hdr.OptionalHeader.Magic == IMAGE_NT_OPTIONAL_HDR_MAGIC )
		(System->Running())->ErrorCode( OK );						// La signatura s correcta
	else
		(System->Running())->ErrorCode( LDR_BAD_PE_HDR );		// dwErrorCode en l'estructura PE
	}

// **************************************************************************
// Certifica que el fitxer s un executable
VOID CExecutableFile::CertifyExecutable()
	{
// Comprovem que tingui una capcelera del DOS MZ
	Check_MZ_HDR();
// Si no hi ha error comprovem tamb la capcelera NT/Akula PE
	if( !(System->Running())->ErrorCode() )
		Check_PE_HDR();
// Si no hi ha error, el fitxer ja est certificat com a vlid
	if( !(System->Running())->ErrorCode() )
		bcertified = TRUE;
	}

// **************************************************************************
// Retorna el valor de la mquina (processador) que es necessita per a executar el programa
WORD CExecutableFile::Machine()
	{
	if( !bcertified )
		(System->Running())->ErrorCode( LDR_NOT_CERTIFIED );				// Si no est certificat hi ha error
// Retornem de tota manera un valor
	return akula_hdr.FileHeader.Machine;
	}

// **************************************************************************
// Retorna el nombre de seccions del fitxer
WORD CExecutableFile::NumberOfSections()
	{
	if( !bcertified )
		(System->Running())->ErrorCode( LDR_NOT_CERTIFIED );				// Si no est certificat hi ha error
// Retornem sempre un valor
	return akula_hdr.FileHeader.NumberOfSections;
	}

// **************************************************************************
// Retorna els flags globals del fitxer (IMAGE_FILE_HEADER.Characteristics)
WORD CExecutableFile::FileFlags()
	{
	if( !bcertified )
		(System->Running())->ErrorCode( LDR_NOT_CERTIFIED );				// Si no est certificat hi ha error
// Retornem sempre un valor
	return akula_hdr.FileHeader.Characteristics;
	}

// **************************************************************************
// Retorna el tamany del codi
DWORD CExecutableFile::SizeOfCode()
	{
	if( !bcertified )
		(System->Running())->ErrorCode( LDR_NOT_CERTIFIED );				// Si no est certificat hi ha error
// Retornem sempre un valor
	return akula_hdr.OptionalHeader.SizeOfCode;
	}

// **************************************************************************
// Retorna el tamany de les dades inicialitzades
DWORD	CExecutableFile::SizeOfInitializedData()
	{
	if( !bcertified )
		(System->Running())->ErrorCode( LDR_NOT_CERTIFIED );				// Si no est certificat hi ha error
// Retornem sempre un valor
	return akula_hdr.OptionalHeader.SizeOfInitializedData;
	}

// **************************************************************************
// Retorna el tamany de les dades sense inicialitzar
DWORD	CExecutableFile::SizeOfUninitializedData()
	{
	if( !bcertified )
		(System->Running())->ErrorCode( LDR_NOT_CERTIFIED );				// Si no est certificat hi ha error
// Retornem sempre un valor
	return akula_hdr.OptionalHeader.SizeOfUninitializedData;
	}

// **************************************************************************
// Retorna l'adrea del punt d'entrada
DWORD	CExecutableFile::AddressOfEntryPoint()
	{
	if( !bcertified )
		(System->Running())->ErrorCode( LDR_NOT_CERTIFIED );				// Si no est certificat hi ha error
// Retornem sempre un valor
	return akula_hdr.OptionalHeader.AddressOfEntryPoint;
	}

// **************************************************************************
// Retorna la base de la imatge
DWORD	CExecutableFile::ImageBase()
	{
	if( !bcertified )
		(System->Running())->ErrorCode( LDR_NOT_CERTIFIED );				// Si no est certificat hi ha error
// Retornem sempre un valor
	return akula_hdr.OptionalHeader.ImageBase;
	}

// **************************************************************************
// Retorna el tamany d'aliniament de les seccions
DWORD	CExecutableFile::SectionAlignment()
	{
	if( !bcertified )
		(System->Running())->ErrorCode( LDR_NOT_CERTIFIED );				// Si no est certificat hi ha error
// Retornem sempre un valor
	return akula_hdr.OptionalHeader.SectionAlignment;
	}

// **************************************************************************
// Retorna el tamany d'aliniament en el fitxer
DWORD	CExecutableFile::FileAlignment()
	{
	if( !bcertified )
		(System->Running())->ErrorCode( LDR_NOT_CERTIFIED );				// Si no est certificat hi ha error
// Retornem sempre un valor
	return akula_hdr.OptionalHeader.FileAlignment;
	}

// **************************************************************************
// Retorna la versi del sistema operatiu esperat
DWORD	CExecutableFile::OperatingSystemVersion()
	{
	if( !bcertified )
		(System->Running())->ErrorCode( LDR_NOT_CERTIFIED );				// Si no est certificat hi ha error
// Retornem sempre un valor
	return MAKELONG( akula_hdr.OptionalHeader.MinorOperatingSystemVersion, akula_hdr.OptionalHeader.MajorOperatingSystemVersion );
	}

// **************************************************************************
// Retorna la versi del subsistema esperat
DWORD	CExecutableFile::SubsystemVersion()
	{
	if( !bcertified )
		(System->Running())->ErrorCode( LDR_NOT_CERTIFIED );				// Si no est certificat hi ha error
// Retornem sempre un valor
	return MAKELONG( akula_hdr.OptionalHeader.MinorSubsystemVersion, akula_hdr.OptionalHeader.MajorSubsystemVersion );
	}

// **************************************************************************
// Retorna el tamany total de la imatge
DWORD	CExecutableFile::SizeOfImage()
	{
	if( !bcertified )
		(System->Running())->ErrorCode( LDR_NOT_CERTIFIED );				// Si no est certificat hi ha error
// Retornem sempre un valor
	return akula_hdr.OptionalHeader.SizeOfImage;
	}

// **************************************************************************
// Retorna el tamany de les capceleres
DWORD	CExecutableFile::SizeOfHeaders()
	{
	if( !bcertified )
		(System->Running())->ErrorCode( LDR_NOT_CERTIFIED );				// Si no est certificat hi ha error
// Retornem sempre un valor
	return akula_hdr.OptionalHeader.SizeOfHeaders;
	}

// **************************************************************************
// Retorna el valor de comprovaci
DWORD	CExecutableFile::CheckSum()
	{
	if( !bcertified )
		(System->Running())->ErrorCode( LDR_NOT_CERTIFIED );				// Si no est certificat hi ha error
// Retornem sempre un valor
	return akula_hdr.OptionalHeader.CheckSum;
	}

// **************************************************************************
// Retorna el subsistema de la imatge
WORD CExecutableFile::Subsystem()
	{
	if( !bcertified )
		(System->Running())->ErrorCode( LDR_NOT_CERTIFIED );				// Si no est certificat hi ha error
// Retornem sempre un valor
	return akula_hdr.OptionalHeader.Subsystem;
	}

// **************************************************************************
// Retorna 'flags' per a les DLL
WORD CExecutableFile::DLLCharacteristics()
	{
	if( !bcertified )
		(System->Running())->ErrorCode( LDR_NOT_CERTIFIED );				// Si no est certificat hi ha error
// Retornem sempre un valor
	return akula_hdr.OptionalHeader.DllCharacteristics;
	}

// **************************************************************************
// Retorna el tamany de pila que s'ha de reservar
DWORD	CExecutableFile::SizeOfStackReserve()
	{
	if( !bcertified )
		(System->Running())->ErrorCode( LDR_NOT_CERTIFIED );				// Si no est certificat hi ha error
// Retornem sempre un valor
	return akula_hdr.OptionalHeader.SizeOfStackReserve;
	}

// **************************************************************************
// Retorna el tamany de pila que s'ha de comprometre
DWORD	CExecutableFile::SizeOfStackCommit()
	{
	if( !bcertified )
		(System->Running())->ErrorCode( LDR_NOT_CERTIFIED );				// Si no est certificat hi ha error
// Retornem sempre un valor
	return akula_hdr.OptionalHeader.SizeOfStackCommit;
	}

// **************************************************************************
// Retorna el tamany de 'heap' que s'ha de reservar
DWORD	CExecutableFile::SizeOfHeapReserve()
	{
	if( !bcertified )
		(System->Running())->ErrorCode( LDR_NOT_CERTIFIED );				// Si no est certificat hi ha error
// Retornem sempre un valor
	return akula_hdr.OptionalHeader.SizeOfHeapReserve;
	}

// **************************************************************************
// Retorna el tamany de 'heap' que s'ha de comprometre
DWORD	CExecutableFile::SizeOfHeapCommit()
	{
	if( !bcertified )
		(System->Running())->ErrorCode( LDR_NOT_CERTIFIED );				// Si no est certificat hi ha error
// Retornem sempre un valor
	return akula_hdr.OptionalHeader.SizeOfHeapCommit;
	}

// **************************************************************************
// Retorna el nombre d'entrades en la taula de 'RVAAndSizes'
DWORD	CExecutableFile::NumberOfRVAAndSizes()
	{
	if( !bcertified )
		(System->Running())->ErrorCode( LDR_NOT_CERTIFIED );				// Si no est certificat hi ha error
// Retornem sempre un valor
	return akula_hdr.OptionalHeader.NumberOfRvaAndSizes;
	}

// **************************************************************************
// Retorna el desplaament cap a la primera entrada de la taula de seccions
DWORD CExecutableFile::FirstSection()
	{
	return dwfirstsection;
	}

// **************************************************************************
// Retorna l'objecte fitxer
PCdrvUserFile CExecutableFile::UserFile()
	{
	return pfile;
	}

