/* **************************************************************************
*                                                                           *
*  ObjDir.CPP                                                               *
*                                                                           *
*  03-02-97                                                    BUILD:0002   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classe per al control dels directoris d'objectes                         *
*                                                                           *
************************************************************************** */

#include "sys\private\objdir.h"
#include "kernel\objdir.h"

// **************************************************************************
// Constructor de la classe
// Com a entrada ha de rebre:
// Object  			- Objecte pare del directori
// Name    			- Nom del directori
CObjectDirectory::CObjectDirectory( PCObject pObject, PSTR sName ) : CObject()
	{
	id = CID_ObjectDirectory;
	pobject = new CkeObjectDirectory( (PCkeObject) pObject->GetInternalPointer(), sName );
	}

// **************************************************************************
// Destructor de la classe
CObjectDirectory::~CObjectDirectory()
	{
	delete pobject;
	}

BOOL CObjectDirectory::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_ObjectDirectory )
		return TRUE;
	else
		return CObject::ClassCheck( Cuid );
	}

// **************************************************************************
// Cerca un objecte en l'estructura de directoris
// Com a entrada ha de rebre:
// Name    			- Nom que estem cercant
PCObject CObjectDirectory::Analysis( PSTR ) // -BUG
	{
	return NULL;
	}

// **************************************************************************
// Retorna l'objecte que s el primer fill del directori
PCObject CObjectDirectory::FirstChild()
	{
	return pchild;
	}

// **************************************************************************
// Afegeix un fill al directori
// Com a entrada ha de rebre:
// Object  			- Objecte que volem afegir
VOID CObjectDirectory::AddChild( PCObject pObject )
	{
	((PCkeObjectDirectory) pobject)->AddChild( (PCkeObject) pObject->GetInternalPointer() );

	if( pchild )
		{
		pObject->SetPrev( NULL );
		pObject->SetNext( pchild );
		pchild->SetPrev( pObject );
		}

	pchild = pObject;
	}

// **************************************************************************
// Elimina un fill del directori
// Com a entrada ha de rebre:
// Object  			- Objecte que volem treure
VOID CObjectDirectory::DeleteChild( PCObject pObject )
	{
	PCObject pitem = pchild;
	BOOL bfound = (pitem == pObject ? TRUE : FALSE);

	while( !bfound && pitem )
		{
		pitem = (PCObject) pitem->GetNext();
		bfound = (pitem == pObject ? TRUE : FALSE);
		}

	if( bfound )
		delete pObject;	// Treure de les llistes? -BUG
	}

