/* **************************************************************************
*                                                                           *
*  Section.CPP                                                              *
*                                                                           *
*  04-03-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classe per a la utilitzaci de les seccions                              *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "sys\private\section.h"
#include "errors.h"
#include "string.h"
#include "kernel\system.h"
#include "kernel\kernel.h"

#ifdef _DEBUG
extern DWORD _import DebugLevel;
#endif
extern PCkeKernel _import Kernel;

LONG Compare( PSTR, PSTR, DWORD ); // Compara dues cadenes de carcters

// **************************************************************************
// Constructor de la classe
// Com a entrada ha de rebre:
// Exe     		- Objecte que representa a un fitxer executable
CSection::CSection( PCExecutableFile pExe )
	{
	id					= CID_Section;
	pexe				= pExe;
	binitialized	= FALSE;
	}

// **************************************************************************
// Destructor de la classe
CSection::~CSection()
	{
	binitialized = FALSE;
	}

BOOL CSection::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_Section )
		return TRUE;
	else
		return CkeType::ClassCheck( Cuid );
	}

// **************************************************************************
// Retorna el nom de la secci
ASTR CSection::Name()
	{
	if( binitialized )
		{
		(System->Running())->ErrorCode( OK );
		return (ASTR) &section.Name;
		}
	else
		{
		(System->Running())->ErrorCode( SECTN_UNINITIALIZED );
		return NULL;
		}
	}

// **************************************************************************
// Retorna el tamany virtual de la secci
DWORD CSection::VirtualSize()
	{
	if( binitialized )
		{
		(System->Running())->ErrorCode( OK );
		return section.Misc.VirtualSize;
		}
	else
		{
		(System->Running())->ErrorCode( SECTN_UNINITIALIZED );
		return 0L;
		}
	}

// **************************************************************************
// Retorna l'adrea virtual de la secci
DWORD CSection::VirtualAddress()
	{
	if( binitialized )
		{
		(System->Running())->ErrorCode( OK );
		return section.VirtualAddress;
		}
	else
		{
		(System->Running())->ErrorCode( SECTN_UNINITIALIZED );
		return 0L;
		}
	}

// **************************************************************************
// Retorna el tamany fsic de la secci
DWORD CSection::SizeOfRawData()
	{
	if( binitialized )
		{
		(System->Running())->ErrorCode( OK );
		return section.SizeOfRawData;
		}
	else
		{
		(System->Running())->ErrorCode( SECTN_UNINITIALIZED );
		return 0L;
		}
	}

// **************************************************************************
// Retorna la posici del fitxer en la qual comena la secci
DWORD CSection::PointerToRawData()
	{
	if( binitialized )
		{
		(System->Running())->ErrorCode( OK );
		return section.PointerToRawData;
		}
	else
		{
		(System->Running())->ErrorCode( SECTN_UNINITIALIZED );
		return 0L;
		}
	}

// **************************************************************************
// Retorna les caracterstiques de la secci
DWORD CSection::Characteristics()
	{
	if( binitialized )
		{
		(System->Running())->ErrorCode( OK );
		return section.Characteristics;
		}
	else
		{
		(System->Running())->ErrorCode( SECTN_UNINITIALIZED );
		return 0L;
		}
	}

// **************************************************************************
// Inicialitza l'objecte obtenint informaci sobre la secci
// Com a entrada ha de rebre:
// Name    		- Nom de la secci que s'est cercant
VOID CSection::Initialize( ASTR sName )
	{
	DWORD dwSectionPos = pexe->FirstSection(); // Obtenim la posici de la taula de seccions
	PCdrvUserFile pfile = pexe->UserFile(); // Obtenim l'objecte fitxer

	pfile->Seek( dwSectionPos, SEEK_SET ); // Anem cap a la posici correcta

	WORD wSections = pexe->NumberOfSections();
	BOOL bFound = FALSE;

	do	{ // Cerquem la secci
		pfile->Read( &section, sizeof( IMAGE_SECTION_HEADER ) );

		if( Compare( section.Name, sName, 8 ) == 0 )
			bFound = TRUE;
		} while( !bFound && wSections-- );

	if( bFound )
		{
		binitialized = TRUE; // Secci trobada
		(System->Running())->ErrorCode( OK );
		}
	else
		{
		binitialized = FALSE; // No s'ha trobat la secci
		(System->Running())->ErrorCode( SECTN_NOTFOUND );
		}
	}

// **************************************************************************
// Portem la secci cap a la memria
// Com a entrada ha de rebre:
// Proc    		- Procs que gestionar la secci
VOID CSection::Read( PCkeProcess pProc )
	{
	if( binitialized )
		{
		DWORD dwaddress = VirtualAddress() + pexe->ImageBase(); // Calculem l'adrea de la secci
		PCkeRegion region = new CkeRegion( NULL, VirtualSize(), 0, NULL ); // Creem una regi per a la secci

		if( pProc->TryToMap( region, (PVOID) dwaddress, 0 ) ) // Provem de mapejar-la
			{
			pProc->Commit( (PVOID) dwaddress, VirtualSize() );
			PCdrvUserFile pfile = pexe->UserFile();
			pfile->Seek( PointerToRawData(), SEEK_SET );
			pfile->Read( (PVOID) dwaddress, SizeOfRawData() );
			}
		else // No s'ha pogut mapejar
			{
			CHAR str[ 80 ];
			sprintf( str, TEXT( "SectionRead - TryToMap de %08x fins %08x ERROR!\r\n" ), dwaddress, VirtualSize() );
			(System->Console())->OutText( str );
			}
		}
	}

// **************************************************************************
// Compara dues cadenes fins al carcter NUL, un espai o 'Size'
// Com a entrada ha de rebre:
// str1    		- Cadena de carcters 1
// str2    		- Cadena de carcters 2
// Size    		- Tamany mxim a comparar
LONG Compare( PSTR str1, PSTR str2, DWORD dwSize )
	{
	BOOL bOK = TRUE;

	while( dwSize && *str1 && *str2 && bOK )
		{
		if( *str1 != *str2 )
			{
			if( (*str1 == 0 || *str1 == 20) && (*str2 == 0 || *str2 == 20) )
				bOK = TRUE; // Al primer zero o 20, parem (comparaci correcta)
			else
				bOK = FALSE;
			}

		str1++;
		str2++;
		dwSize--;
		}

	if( bOK )
		return 0; // Cadenes iguals

	if( *str1 < *str2 )
		return -1;
	else
		return 1;
	}

