/* **************************************************************************
*                                                                           *
*  Thread.CPP                                                               *
*                                                                           *
*  03-02-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classe per a la gesti dels fluxos                                       *
*                                                                           *
************************************************************************** */

#include "sys\private\thread.h"
#include "kernel\thread.h"

// **************************************************************************
// Constructor de la classe
// Com a entrada ha de rebre:
// Object  			- Objecte intern que s representat per aquest objecte de nivell sistema
CThread::CThread( PVOID pObject ) : CResource( (PCkeObject) pObject )
	{
	id = CID_Thread;
	}

// **************************************************************************
// Destructor de la classe
CThread::~CThread()
	{
	}

BOOL CThread::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_Thread )
		return TRUE;
	else
		return CResource::ClassCheck( Cuid );
	}

// **************************************************************************
// Retorna el codi d'error del flux
DWORD CThread::ErrorCode()
	{
	return ((PCkeThread) pobject)->ErrorCode();
	}

// **************************************************************************
// Retorna el temps d'execuci en mode 'kernel'
DWORD CThread::KernelTime()
	{
	return ((PCkeThread) pobject)->KernelTime();
	}

// **************************************************************************
// Retorna el temps d'execuci en mode 'user'
DWORD CThread::UserTime()
	{
	return ((PCkeThread) pobject)->UserTime();
	}

// **************************************************************************
// Canvia el codi d'error del flux
// Com a entrada ha de rebre:
// Code    			- Nou codi
VOID CThread::ErrorCode( DWORD dwCode )
	{
	((PCkeThread) pobject)->ErrorCode( dwCode );
	}

// **************************************************************************
// Constructor de la classe
PCkeThread CThread::NextInProc() // -BUG
	{
	return ((PCkeThread) pobject)->NextInProc();
	}

// **************************************************************************
// Constructor de la classe
PCkeThread CThread::PrevInProc() // -BUG
	{
	return ((PCkeThread) pobject)->PrevInProc();
	}

// **************************************************************************
// Constructor de la classe
PCkeThread CThread::NextInAll() // -BUG
	{
	return ((PCkeThread) pobject)->NextInAll();
	}

// **************************************************************************
// Constructor de la classe
PCkeThread CThread::PrevInAll() // -BUG
	{
	return ((PCkeThread) pobject)->PrevInAll();
	}

// **************************************************************************
// Constructor de la classe
// Com a entrada ha de rebre:
// Name    			- Nom de l'usuari o grup
VOID CThread::NextInProc( PCkeThread )
	{
	}

// **************************************************************************
// Constructor de la classe
// Com a entrada ha de rebre:
// Name    			- Nom de l'usuari o grup
VOID CThread::PrevInProc( PCkeThread )
	{
	}

// **************************************************************************
// Constructor de la classe
// Com a entrada ha de rebre:
// Name    			- Nom de l'usuari o grup
VOID CThread::NextInAll( PCkeThread )
	{
	}

// **************************************************************************
// Constructor de la classe
// Com a entrada ha de rebre:
// Name    			- Nom de l'usuari o grup
VOID CThread::PrevInAll( PCkeThread )
	{
	}

// **************************************************************************
// Retorna la prioritat actual del flux
BYTE CThread::Priority()
	{
	return ((PCkeThread) pobject)->Priority();
	}

// **************************************************************************
// Canvia la prioritat del flux
// Com a entrada ha de rebre:
// Priority			- Nova prioritat del flux
VOID CThread::Priority( BYTE cPriority )
	{
	((PCkeThread) pobject)->Priority( cPriority );
	}

// **************************************************************************
// Retorna el procs al qual pertany el flux
PCProcess CThread::Process()
	{
	return NULL;	// -BUG
	}

// **************************************************************************
// Retorna l'hora de creaci del flux (respecte l'inici del sistema)
DWORD CThread::CreationTime()
	{
	return ((PCkeThread) pobject)->CreationTime();
	}

// **************************************************************************
// Consulta el codi de sortida del flux
DWORD CThread::ExitStatus()
	{
	return ((PCkeThread) pobject)->ExitStatus();
	}

// **************************************************************************
// Finalitza el flux amb el codi corresponent
// Com a entrada ha de rebre:
// Code    			- Codi de sortida que deixa el flux
VOID CThread::Exit( DWORD dwCode )
	{
	((PCkeThread) pobject)->Exit( dwCode );
	}

