/* **************************************************************************
*                                                                           *
*  Timer.CPP                                                                *
*                                                                           *
*  03-02-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classe per a la utilitzaci d'alarmes                                    *
*                                                                           *
************************************************************************** */

#include "sys\private\timer.h"
#include "kernel\timer.h"

// **************************************************************************
// Constructor de la classe
// Com a entrada ha de rebre:
// TimeOut 			- Interval de l'alarma
// MailBox 			- Bstia on s'envien els missatges de l'alarma
// Object  			- Objecte que ser el pare de l'alarma
// Name    			- Nom de l'alarma
CTimer::CTimer( LONG lTimeOut, PCMailBox pMailbox, PCObject pObject, PSTR sName ) : CCallback( NULL, NULL, NULL )
	{
	id = CID_Timer;

	if( !pObject ) // Si no t pare
		pobject = new CkeTimer( lTimeOut, (PCkeMailBox) pMailbox->GetInternalPointer(), NULL, sName );
	else // Si t pare
		pobject = new CkeTimer( lTimeOut, (PCkeMailBox) pMailbox->GetInternalPointer(), (PCkeObject) pObject->GetInternalPointer(), sName );
	}

// **************************************************************************
// Destructor de la classe
CTimer::~CTimer()
	{
	}

BOOL CTimer::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_Timer )
		return TRUE;
	else
		return CResource::ClassCheck( Cuid );
	}

// **************************************************************************
// Retorna l'interval de l'alarma
DWORD CTimer::Time()
	{
	return ((PCkeTimer) pobject)->Time();
	}

// **************************************************************************
// Canvia l'interval de l'alarma
// Com a entrada ha de rebre:
// TimeOut 			- Nou interval
VOID CTimer::Time( LONG lTimeOut )
	{
	((PCkeTimer) pobject)->Time( lTimeOut );
	}

