/* **************************************************************************
*                                                                           *
*  Callback.CPP                                                             *
*                                                                           *
*  31-01-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classe per a la gesti de les funcions de 'Callback'                     *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "sys\callback.h"
#include "sys\mailbox.h"
#include "sys\asm.h"
#include "sys\sys.h"

CsysCallback::CsysCallback( PCsysMailBox pMailBox, PCsysObject pParent, PSTR sName ) : CsysResource()
	{
	id = CID_Callback;

	if( pMailBox )
		Create( pMailBox, pParent, sName );
	}

CsysCallback::~CsysCallback()
	{
	if( id == CID_Callback )
		Destroy();
	}

BOOL CsysCallback::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_Callback )
		return TRUE;
	else
		return CsysResource::ClassCheck( Cuid );
	}

VOID CsysCallback::Create( PCsysMailBox pMailBox, PCsysObject pParent, PSTR sName )
	{
	PCsysMailBox box = new CsysMailBox();

	TData data;
	data.dwParam1	= (DWORD) sName;
	data.dwParam2	= (DWORD) pMailBox->GetInternalPointer();

	TMSG msg;

	msg.dwMessage	= SYS_CREATE_CALLBACK;
	msg.dwParam1	= (DWORD) pParent;
	msg.dwParam2	= (DWORD) &data;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	pobject = (PVOID) msg.dwParam1;
	}

VOID CsysCallback::Destroy()
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_DESTROY_CALLBACK;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

