/* **************************************************************************
*                                                                           *
*  Console.CPP                                                              *
*                                                                           *
*  14-03-97                                                    BUILD:0003   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Control de la pantalla                                                   *
*                                                                           *
************************************************************************** */

#include "sys\console.h"
#include "errors.h"
#include "sys\mailbox.h"
#include "sys\asm.h"
#include "sys\sys.h"
#include "string.h"

// **************************************************************************
// Constructor de la classe
CsysConsole::CsysConsole() : CsysType( CID_Console )
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_CREATE_CONSOLE;
	msg.dwParam1	= (DWORD) GetInternalThread();
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	pconsole = (PVOID) msg.dwParam1;
	}

// **************************************************************************
// Destructor de la classe
CsysConsole::~CsysConsole()
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_DESTROY_CONSOLE;
	msg.dwParam1	= (DWORD) pconsole;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

// **************************************************************************
// Indica si la classe de l'objecte es o no la que es passa com a parametre
// Com a entrada ha de rebre:
// Cuid     	- Identificador de la classe
BOOL CsysConsole::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_Console )
		return TRUE;
	else
		return CsysType::ClassCheck( Cuid );
	}

// **************************************************************************
// Escriu el text indicat per pantalla
// Com a entrada ha de rebre:
// str      	- Cadena de carcters a escriure
VOID CsysConsole::OutText( PSTR str )
	{
	PSTR string = (PSTR) malloc( strlen( str ) + 1 );
	strcpy( string, str );

	TMSG msg;

	msg.dwMessage	= SYS_OUTTEXT_CONSOLE;
	msg.dwParam1	= (DWORD) pconsole;
	msg.dwParam2	= (DWORD) string;
	msg.pReply		= SYSModule->NULLMailBox();

	PostMessage( SYSModule->MailBox(), &msg );
	}

// **************************************************************************
// Selecciona la nova possici del cursor dins la pantalla
// Com a entrada ha de rebre:
// x        	- Columna desitjada
// y        	- Fila desitjada
VOID CsysConsole::GotoXY( BYTE x, BYTE y )
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_GOTOXY_CONSOLE;
	msg.dwParam1	= (DWORD) pconsole;
	msg.dwParam2	= (DWORD) (x + ((DWORD) y << 8));
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

// **************************************************************************
// Esborra la pantalla pintant-la amb gris sobre negre
VOID CsysConsole::Clear()
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_CLEAR_CONSOLE;
	msg.dwParam1	= (DWORD) pconsole;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

