/* **************************************************************************
*                                                                           *
*  List.CPP                                                                 *
*                                                                           *
*  30-01-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classes genriques per a llistes i llistes doblement encadenades         *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "sys\list.h"
#include "errors.h"
#include "sys\sys.h"

// **************************************************************************
// Constructor de la classe
// Com a entrada ha de rebre:
// next     	- Apunta a l'element seguent de la llista
CsysListItem::CsysListItem( PCsysListItem next ) : CsysType( CID_ListItem )
	{
	SetNext( next );
	}

// **************************************************************************
// Destrueix l'objecte
CsysListItem::~CsysListItem()
	{
// Hauriem de treure'l de la llista -BUG
	}

// **************************************************************************
// Indica si la classe de l'objecte es o no la que es passa com a parametre
// Com a entrada ha de rebre:
// Cuid     	- Identificador de la classe
BOOL CsysListItem::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_ListItem )
		return TRUE;
	else
		return CsysType::ClassCheck( Cuid );
	}

// **************************************************************************
// Retorna l'objecte seguent de la llista
PCsysListItem CsysListItem::GetNext()
	{
	return pnext;
	}

// **************************************************************************
// Selecciona l'objecte seguent de la llista
// Com a entrada ha de rebre:
// next     	- Apuntador al nou objecte seguent
void CsysListItem::SetNext( PCsysListItem next )
	{
	pnext			= next;
	}

// **************************************************************************
// Constructor de la classe
// Com a entrada ha de rebre:
// prev     	- Objecte anterior
// next     	- Objecte seguent
CsysDblListItem::CsysDblListItem( PCsysDblListItem prev, PCsysDblListItem next ) : CsysListItem( (PCsysListItem) next )
	{
//	TRACE( TEXT( "CsysDblListItem::CsysDblListItem" ) );

	id	= CID_DblListItem;
	SetPrev( prev );
	}

// **************************************************************************
// Destrueix l'objecte
CsysDblListItem::~CsysDblListItem()
	{
	// Primer l'hem de treure de la llista? -BUG
	}

// **************************************************************************
// Indica si la classe de l'objecte es o no la que es passa com a parametre
// Com a entrada ha de rebre:
// Cuid     	- Identificador de la classe
BOOL CsysDblListItem::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_DblListItem )
		return TRUE;
	else
		return CsysListItem::ClassCheck( Cuid );
	}

// **************************************************************************
// Retorna l'objecte anterior de la llista
PCsysDblListItem CsysDblListItem::GetPrev()
	{
	return pprev;
	}

// **************************************************************************
// Selecciona un nou objecte anterior
// Com a entrada ha de rebre:
// prev     	- Objecte que sera el nou anterior
void CsysDblListItem::SetPrev( CsysDblListItem *prev )
	{
	pprev			= prev;
	}

CsysLIFOList::CsysLIFOList() : CsysType( CID_LIFOList )
	{
	pfirst = NULL;
	dwelements = 0L;
	}

CsysLIFOList::~CsysLIFOList()
	{
// Hem d'esborrar tots els elements? -BUG
	}

PCsysListItem CsysLIFOList::Get()
	{
	return pfirst;
	}

VOID CsysLIFOList::Add( PCsysListItem pItem )
	{
	dwelements++;
	pItem->SetNext( pfirst );

	if( pfirst )
		{
		if( pfirst->ClassCheck( CID_DblListItem ) )
			((PCsysDblListItem) pfirst)->SetPrev( (PCsysDblListItem) pItem );
		}

	pfirst = pItem;
	}

VOID CsysLIFOList::Delete( PCsysListItem pItem )
	{
	if( pfirst )
		{
		if( pfirst == pItem )
			{
			pfirst = pItem->GetNext();

			if( pfirst && pfirst->ClassCheck( CID_DblListItem ) )
				((PCsysDblListItem) pfirst)->SetPrev( NULL );
			}
		else
		if( pItem->ClassCheck( CID_DblListItem ) )
			{
			PCsysListItem pelem = ((PCsysDblListItem) pItem)->GetPrev();

			pelem->SetNext( pItem->GetNext() );
			if( pItem->GetNext() )
				((PCsysDblListItem) pItem->GetNext())->SetPrev( (PCsysDblListItem) pelem );
			}
		else
			{
			PCsysListItem pelem = pfirst;

			while( pelem->GetNext() != pItem && pelem->GetNext() )
				pelem = pelem->GetNext();

			if( pelem->GetNext() == pItem )
				pelem->SetNext( pItem->GetNext() );
			}

		dwelements--;
		}
	}

CsysFIFOList::CsysFIFOList() : CsysLIFOList()
	{
	id	= CID_FIFOList;
	plast = NULL;
	}

CsysFIFOList::~CsysFIFOList()
	{
// Hem d'esborrar tots els elements -BUG
	}

PCsysListItem CsysFIFOList::Get()
	{
	return pfirst;
	}

VOID CsysFIFOList::Add( PCsysListItem pItem )
	{
	pItem->SetNext( NULL ); // Per si no s'ha fet -BUG
	dwelements++;

	if( plast )
		plast->SetNext( pItem );
	else
		pfirst = pItem;

	if( pItem->ClassCheck( CID_DblListItem ) )
		((PCsysDblListItem) pItem)->SetPrev( (PCsysDblListItem) plast );

	plast = pItem;
	}

VOID CsysFIFOList::Delete( PCsysListItem pItem )
	{
	if( pfirst )
		{
		if( pfirst == pItem )
			{
			pfirst = pItem->GetNext();

			if( pfirst->ClassCheck( CID_DblListItem ) )
				((PCsysDblListItem) pfirst)->SetPrev( NULL );
			}
		else
		if( pItem->ClassCheck( CID_DblListItem ) )
			{
			(((PCsysDblListItem) pItem)->GetPrev())->SetNext( pItem->GetNext() );
			((PCsysDblListItem) pItem->GetNext())->SetPrev( ((PCsysDblListItem) pItem)->GetPrev() );
			}
		else
			{
			PCsysListItem pelem = pfirst;

			while( pelem->GetNext() != pItem && pelem->GetNext() )
				pelem = pelem->GetNext();

			if( pelem->GetNext() == pItem )
				{
				pelem->SetNext( pItem->GetNext() );

				if( pItem == plast )
					plast = pelem;
				}
			}

		dwelements--;
		}
	}

