/* **************************************************************************
*                                                                           *
*  Mutex.CPP                                                                *
*                                                                           *
*  01-02-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classe per a la utilitzaci de 'mutex'                                   *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "sys\mutex.h"
#include "sys\mailbox.h"
#include "sys\asm.h"
#include "sys\sys.h"

CsysMutex::CsysMutex( PCsysObject pParent, PSTR sName ) : CsysResource()
	{
	id = CID_Mutex;

	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_CREATE_MUTEX;

	if( pParent )
		msg.dwParam1	= (DWORD) pParent->GetInternalPointer();
	else
		msg.dwParam1	= 0;

	msg.dwParam2	= (DWORD) sName;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	pobject = (PVOID) msg.dwParam1;
	}

CsysMutex::~CsysMutex()
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_DESTROY_MUTEX;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

BOOL CsysMutex::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_Mutex )
		return TRUE;
	else
		return CsysResource::ClassCheck( Cuid );
	}

