/* **************************************************************************
*                                                                           *
*  ObjDir.CPP                                                               *
*                                                                           *
*  30-01-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classe per al control dels directori d'objectes                          *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "sys\objdir.h"
#include "string.h"
#include "errors.h"
#include "sys\mailbox.h"
#include "sys\asm.h"
#include "sys\sys.h"

// **************************************************************************
// Constructor de la classe
// Com a entrada ha de rebre:
// sName    	- Cadena de caracters amb el nom del directori
// bTemp    	- Indica si el directori es temporal
CsysObjectDirectory::CsysObjectDirectory( PCsysObject pParent, PSTR sName ) : CsysObject()
	{
	id = CID_ObjectDirectory;

	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_CREATE_OBJECTDIRECTORY;

	if( pParent )
		msg.dwParam1	= (DWORD) pParent->GetInternalPointer();
	else
		msg.dwParam1	= 0;

	msg.dwParam2	= (DWORD) sName;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	pobject = (PVOID) msg.dwParam1;
	}

// **************************************************************************
// Destructor de l'objecte
CsysObjectDirectory::~CsysObjectDirectory()
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_DESTROY_MUTEX;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

// **************************************************************************
// Indica si la classe de l'objecte es o no la que es passa com a parametre
// Com a entrada ha de rebre:
// Cuid     	- Identificador de la classe
BOOL CsysObjectDirectory::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_ObjectDirectory )
		return TRUE;
	else
		return CsysObject::ClassCheck( Cuid );
	}

// **************************************************************************
// Retorna l'objecte que s'esta cercant
// Com a entrada ha de rebre:
// Name	    	- Nom de l'objecte que es vol trobar
PCsysObject CsysObjectDirectory::Analysis( PSTR sName )
	{
	CsysMailBox box;

	TMSG msg;

	msg.dwMessage	= SYS_ANALYSIS_OBJECT;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= (DWORD) sName;
	msg.pReply		= box.GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box.WaitMessage( &msg );

	return new CsysObject( (PVOID) msg.dwParam1 );
	}

// **************************************************************************
// Retorna el primer objecte fill del directori
PCsysObject CsysObjectDirectory::FirstChild()
	{
	CsysMailBox box;

	TMSG msg;

	msg.dwMessage	= SYS_FIRSTCHILD_OBJECTDIRECTORY;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 0;
	msg.pReply		= box.GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box.WaitMessage( &msg );

	return new CsysObject( (PVOID) msg.dwParam1 );
	}

// **************************************************************************
// Afegeix un nou objecte al directori
// Com a entrada ha de rebre:
// Object   	- Apuntador a l'objecte que es vol afegir
VOID CsysObjectDirectory::AddChild( PCsysObject pObject )
	{
	CsysMailBox box;

	TMSG msg;

	msg.dwMessage	= SYS_ADDCHILD_OBJECTDIRECTORY;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= (DWORD) pObject->GetInternalPointer();
	msg.pReply		= box.GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box.WaitMessage( &msg );
	}

// **************************************************************************
// Esborra el fill que se li passa com a parmetre
// Com a entrada ha de rebre:
// Object   	- Apuntador a l'objecte que es vol esborrar
VOID CsysObjectDirectory::DeleteChild( PCsysObject pObject )
	{
	CsysMailBox box;

	TMSG msg;

	msg.dwMessage	= SYS_DELETECHILD_OBJECTDIRECTORY;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= (DWORD) pObject->GetInternalPointer();
	msg.pReply		= box.GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box.WaitMessage( &msg );
	}

// **************************************************************************
// Esborra el fill que se li passa com a parmetre
// Com a entrada ha de rebre:
// Name	    	- Nom de l'objecte que es vol esborrar
VOID CsysObjectDirectory::DeleteChild( PSTR sName )
	{
	DeleteChild( Analysis( sName ) );
	}

