/* **************************************************************************
*                                                                           *
*  Object.CPP                                                               *
*                                                                           *
*  31-01-97                                                    BUILD:0004   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ consentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Classe genrica per al control dels recursos i el directori d'objectes   *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "sys\object.h"
#include "errors.h"
#include "string.h"
#include "sys\mem.h"
#include "sys\mailbox.h"
#include "sys\asm.h"
#include "sys\sys.h"
#include "sys\thread.h"

// **************************************************************************
// Constructor de la classe
// Com a entrada ha de rebre:
// Name 	   	- Nom de l'objecte (pot ser NULL)
// Temp  	  	- Indica si es temporal
CsysObject::CsysObject( PVOID pObject ) : CsysDblListItem( NULL, NULL )
	{
	pobject = pObject;
	}

// **************************************************************************
// Destrueix l'objecte
CsysObject::~CsysObject()
	{
	}

// **************************************************************************
// Indica si la classe de l'objecte es o no la que es passa com a parametre
// Com a entrada ha de rebre:
// Cuid     	- Identificador de la classe
BOOL CsysObject::ClassCheck( CUID Cuid )
	{
	if( Cuid == CID_Object )
		return TRUE;
	else
		return CsysDblListItem::ClassCheck( Cuid );
	}

PVOID CsysObject::GetInternalPointer()
	{
	return pobject;
	}

PCsysThread CsysObject::Creator()
	{
	CsysMailBox box;

	TMSG msg;

	msg.dwMessage	= SYS_GETCREATOR_OBJECT;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 0;
	msg.pReply		= box.GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box.WaitMessage( &msg );

	return new CsysThread( (PVOID) msg.dwParam1 );
	}

// **************************************************************************
// Retorna l'adrea de l'objecte despres d'obrir un apuntador cap a ell
// Com a entrada ha de rebre:
// Interrupt	- Identifica la interrupcio en la que es vol registrar
// Address  	- Indica l'adrea de memoria de la RSI
PCsysObject CsysObject::Enter()
	{
	CsysMailBox box;

	TMSG msg;

	msg.dwMessage	= SYS_ENTER_OBJECT;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 0;
	msg.pReply		= box.GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box.WaitMessage( &msg );

	return this;
	}

// **************************************************************************
// Tanca un apuntador cap a l'objecte
VOID CsysObject::Leave()
	{
	CsysMailBox box;

	TMSG msg;

	msg.dwMessage	= SYS_LEAVE_OBJECT;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 0;
	msg.pReply		= box.GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box.WaitMessage( &msg );
	}

// **************************************************************************
// Retorna el nom de l'objecte
VOID CsysObject::Name( PSTR sName, DWORD dwSize )
	{
	CsysMailBox box;

	TData data;
	data.dwParam1	= (DWORD) sName;
	data.dwParam2	= dwSize;

	TMSG msg;

	msg.dwMessage	= SYS_GETNAME_OBJECT;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= (DWORD) &data;
	msg.pReply		= box.GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box.WaitMessage( &msg );
	}

// **************************************************************************
// Retorna el valor del comptador d'apuntadors oberts a l'objecte
DWORD CsysObject::UseCount()
	{
	CsysMailBox box;

	TMSG msg;

	msg.dwMessage	= SYS_GETUSECOUNT_OBJECT;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 0;
	msg.pReply		= box.GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box.WaitMessage( &msg );

	return msg.dwParam1;
	}

// **************************************************************************
// Retorna l'indicador de temporal
BOOL CsysObject::Temporal()
	{
	CsysMailBox box;

	TMSG msg;

	msg.dwMessage	= SYS_GETTEMPORAL_OBJECT;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 0;
	msg.pReply		= box.GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box.WaitMessage( &msg );

	return (BOOL) msg.dwParam1;
	}

// **************************************************************************
// Realitza la funci d'anlisi de la cadena de carcters
// Com a entrada ha de rebre:
// str      	- Cadena de carcters sobre la qual es realitza l'anlisi
PCsysObject CsysObject::Analysis( PSTR )
	{
// Per defecte noms es retorna l'objecte
	return this;
	}

