/* **************************************************************************
*                                                                           *
*  PCB.CPP                                                                  *
*                                                                           *
*  03-02-97                                                    BUILD:0001   *
*                                                                           *
*  (c) Copyright, 1996-1997 de Daniel Vil i Amill                          *
*                                                                           *
*  Aquest fitxer pot ser utilitzat per a l's personal. No es pot vendre el *
*  seu contingut sense el previ pconsentiment per escrit de l'autor.         *
*  El material en aquest fitxer es distribueix "as is" i l'autor no es      *
*  responsabilitza dels danys que pugui causar-ne el seu s.                *
*                                                                           *
*                                                                           *
*  Procs des del punt de vista del mdul System                            *
*                                                                           *
************************************************************************** */

// *********************************** INCLUDES
#include "sys\pcb.h"
#include "sys\mailbox.h"
#include "sys\asm.h"
#include "sys\thread.h"
#include "sys\sys.h"

CsysProcess::CsysProcess( PVOID pObject )	: CsysResource( pObject )
	{
	id = CID_Process;
	}

/*
CsysProcess::CsysProcess( PVOID pParent, PSTR sName )	: CsysResource()
	{
	id = CID_Process;

	PCsysMailBox box = new CsysMailBox();

	TData data;
	data.dwParam1	= (DWORD) sName;

	TMSG msg;

	msg.dwMessage	= SYS_CREATE_PROCESS;
	msg.dwParam1	= (DWORD) pParent;
	msg.dwParam2	= (DWORD) &data;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	pobject = (PVOID) msg.dwParam1;
	}

CsysProcess::CsysProcess( PCsysObject pParent, PSTR sName ) : CsysResource()
	{
	id = CID_Process;

	PCsysMailBox box = new CsysMailBox();

	TData data;
	data.dwParam1	= (DWORD) sName;

	TMSG msg;

	msg.dwMessage	= SYS_CREATE_PROCESS;
	msg.dwParam1	= (DWORD) pParent->GetInternalPointer();
	msg.dwParam2	= (DWORD) &data;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	pobject = (PVOID) msg.dwParam1;
	}
*/
CsysProcess::~CsysProcess()
	{
	}

PCsysUser CsysProcess::User()
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_GETUSER_PROCESS;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	return new CsysUser( (PVOID) msg.dwParam1 );
	}

PVOID CsysProcess::Map( PCsysRegion pRegion, DWORD dwProtection )
	{
	PCsysMailBox box = new CsysMailBox();

	TData data;

	data.dwParam1 = (DWORD) pRegion->GetInternalPointer();
	data.dwParam2 = dwProtection;

	TMSG msg;

	msg.dwMessage	= SYS_MAPREGION_PROCESS;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= (DWORD) &data;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	return (PVOID) msg.dwParam1;
	}

VOID CsysProcess::Unmap( PCsysRegion pRegion )
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_UNMAPREGION_PROCESS;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= (DWORD) pRegion->GetInternalPointer();
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

BOOL CsysProcess::TryToMap( PCsysRegion pRegion, PVOID pAddress, DWORD dwProtection )
	{
	PCsysMailBox box = new CsysMailBox();

	TData data;

	data.dwParam1 = (DWORD) pRegion;
	data.dwParam2 = dwProtection;
	data.dwParam3 = (DWORD) pAddress;

	TMSG msg;

	msg.dwMessage	= SYS_MAPREGION_PROCESS;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= (DWORD) &data;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	return (BOOL) msg.dwParam1;
	}

VOID CsysProcess::Commit( PVOID pAddress, DWORD dwSize )
	{
	PCsysMailBox box = new CsysMailBox();

	TData data;

	data.dwParam1 = (DWORD) pAddress;
	data.dwParam2 = dwSize;

	TMSG msg;

	msg.dwMessage	= SYS_MAPREGION_PROCESS;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= (DWORD) &data;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

PCsysThread CsysProcess::Thread()
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_GETFIRSTTHREAD_PROCESS;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	return new CsysThread( (PVOID) msg.dwParam1 );
	}

BYTE CsysProcess::BasePriority()
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_GETBASEPRIORITY_PROCESS;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	return (BYTE) msg.dwParam1;
	}

VOID CsysProcess::BasePriority( BYTE cPriority )
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_SETBASEPRIORITY_PROCESS;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= (DWORD) cPriority;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;
	}

BOOL CsysProcess::PrivilegeLevel()
	{
	PCsysMailBox box = new CsysMailBox();

	TMSG msg;

	msg.dwMessage	= SYS_GETPRIVILEGELEVEL_PROCESS;
	msg.dwParam1	= (DWORD) pobject;
	msg.dwParam2	= 0;
	msg.pReply		= box->GetInternalPointer();

	PostMessage( SYSModule->MailBox(), &msg );

	box->WaitMessage( &msg );
	delete box;

	return (BOOL) msg.dwParam1;
	}

